/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.graql.internal.analytics.GraknMapReduce;
import ai.grakn.graql.internal.analytics.Utility;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class CountMapReduce
extends GraknMapReduce<Long> {
    public static final String MEMORY_KEY = "count";

    public CountMapReduce() {
    }

    public CountMapReduce(Set<String> types) {
        this.selectedTypes = types;
    }

    public boolean doStage(MapReduce.Stage stage) {
        return true;
    }

    @Override
    public void safeMap(Vertex vertex, MapReduce.MapEmitter<Serializable, Long> emitter) {
        if (!this.selectedTypes.isEmpty()) {
            if (this.selectedTypes.contains(Utility.getVertexType(vertex))) {
                emitter.emit((Object)MEMORY_KEY, (Object)1L);
                return;
            }
        } else if (this.baseTypes.contains(vertex.label())) {
            emitter.emit((Object)MEMORY_KEY, (Object)1L);
            return;
        }
        emitter.emit((Object)MEMORY_KEY, (Object)0L);
    }

    public void combine(Serializable key, Iterator<Long> values, MapReduce.ReduceEmitter<Serializable, Long> emitter) {
        this.reduce(key, values, emitter);
    }

    public void reduce(Serializable key, Iterator<Long> values, MapReduce.ReduceEmitter<Serializable, Long> emitter) {
        emitter.emit((Object)key, IteratorUtils.reduce(values, (Object)0L, (a, b) -> a + b));
    }

    public Map<Serializable, Long> generateFinalResult(Iterator<KeyValue<Serializable, Long>> keyValues) {
        HashMap<Serializable, Long> count = new HashMap<Serializable, Long>();
        keyValues.forEachRemaining(pair -> {
            Long cfr_ignored_0 = (Long)count.put((Serializable)pair.getKey(), (Long)pair.getValue());
        });
        return count;
    }
}

