/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.graql.internal.analytics.GraknVertexProgram;
import ai.grakn.graql.internal.analytics.Utility;
import ai.grakn.util.Schema;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class DegreeVertexProgram
extends GraknVertexProgram<Long> {
    public static final String DEGREE = "medianVertexProgram.degree";
    private static final String OF_TYPE_NAMES = "degreeAndPersistVertexProgram.ofTypeNames";
    private static final Set<String> ELEMENT_COMPUTE_KEYS = Collections.singleton("medianVertexProgram.degree");
    private Set<String> ofTypeNames = new HashSet<String>();

    public DegreeVertexProgram() {
    }

    public DegreeVertexProgram(Set<String> types, Set<String> ofTypeNames) {
        this.selectedTypes = types;
        this.ofTypeNames = ofTypeNames;
    }

    @Override
    public void storeState(Configuration configuration) {
        super.storeState(configuration);
        this.ofTypeNames.forEach(type -> configuration.addProperty("degreeAndPersistVertexProgram.ofTypeNames." + type, type));
    }

    @Override
    public void loadState(Graph graph, Configuration configuration) {
        super.loadState(graph, configuration);
        configuration.subset(OF_TYPE_NAMES).getKeys().forEachRemaining(key -> this.ofTypeNames.add((String)configuration.getProperty("degreeAndPersistVertexProgram.ofTypeNames." + key)));
    }

    public Set<String> getElementComputeKeys() {
        return ELEMENT_COMPUTE_KEYS;
    }

    @Override
    public void safeExecute(Vertex vertex, Messenger<Long> messenger, Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                if (!this.selectedTypes.contains(Utility.getVertexType(vertex))) break;
                this.degreeStep0(vertex, messenger);
                break;
            }
            case 1: {
                if (!vertex.label().equals(Schema.BaseType.CASTING.name())) break;
                this.degreeStep1(messenger);
                break;
            }
            case 2: {
                String type = Utility.getVertexType(vertex);
                if (!this.selectedTypes.contains(type) || !this.ofTypeNames.contains(type)) break;
                vertex.property(DEGREE, (Object)this.getEdgeCount(messenger));
            }
        }
    }

    public boolean terminate(Memory memory) {
        LOGGER.info("Finished Iteration " + memory.getIteration());
        return memory.getIteration() == 2;
    }
}

