/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.graql.internal.analytics.CommonOLAP;
import ai.grakn.graql.internal.analytics.Utility;
import ai.grakn.util.ErrorMessage;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraknMapReduce<T>
extends CommonOLAP
implements MapReduce<Serializable, T, Serializable, T, Map<Serializable, T>> {
    static final Logger LOGGER = LoggerFactory.getLogger(GraknMapReduce.class);
    public static final String MAP_REDUCE_MEMORY_KEY = "GraknMapReduce.memoryKey";

    abstract void safeMap(Vertex var1, MapReduce.MapEmitter<Serializable, T> var2);

    @Override
    public void storeState(Configuration configuration) {
        super.storeState(configuration);
        configuration.setProperty("gremlin.mapReduce", (Object)this.getClass().getName());
    }

    public void map(Vertex vertex, MapReduce.MapEmitter<Serializable, T> emitter) {
        if (Utility.isAlive(vertex)) {
            this.safeMap(vertex, emitter);
        }
    }

    public String getMemoryKey() {
        return MAP_REDUCE_MEMORY_KEY;
    }

    public MapReduce<Serializable, T, Serializable, T, Map<Serializable, T>> clone() {
        try {
            return (GraknMapReduce)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(ErrorMessage.CLONE_FAILED.getMessage(new Object[]{this.getClass().toString(), e.getMessage()}), e);
        }
    }
}

