/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.ResourceType;
import ai.grakn.graql.internal.analytics.GraknMapReduce;
import ai.grakn.graql.internal.analytics.Utility;
import ai.grakn.util.Schema;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class MeanMapReduce
extends GraknMapReduce<Map<String, Double>> {
    public static final String MEMORY_KEY = "mean";
    private static final String RESOURCE_DATA_TYPE_KEY = "RESOURCE_DATA_TYPE_KEY";
    public static final String COUNT = "C";
    public static final String SUM = "S";

    public MeanMapReduce() {
    }

    public MeanMapReduce(Set<String> selectedTypes, String resourceDataType) {
        this.selectedTypes = selectedTypes;
        String resourceDataTypeValue = resourceDataType.equals(ResourceType.DataType.LONG.getName()) ? Schema.ConceptProperty.VALUE_LONG.name() : Schema.ConceptProperty.VALUE_DOUBLE.name();
        this.persistentProperties.put(RESOURCE_DATA_TYPE_KEY, resourceDataTypeValue);
    }

    @Override
    public void safeMap(Vertex vertex, MapReduce.MapEmitter<Serializable, Map<String, Double>> emitter) {
        if (this.selectedTypes.contains(Utility.getVertexType(vertex)) && (Long)vertex.value("medianVertexProgram.degree") > 0L) {
            HashMap<String, Double> tuple = new HashMap<String, Double>(2);
            Double degree = ((Long)vertex.value("medianVertexProgram.degree")).doubleValue();
            tuple.put(SUM, degree * ((Number)vertex.value((String)this.persistentProperties.get(RESOURCE_DATA_TYPE_KEY))).doubleValue());
            tuple.put(COUNT, degree);
            emitter.emit((Object)MEMORY_KEY, tuple);
            return;
        }
        HashMap<String, Double> emptyTuple = new HashMap<String, Double>(2);
        emptyTuple.put(SUM, 0.0);
        emptyTuple.put(COUNT, 0.0);
        emitter.emit((Object)MEMORY_KEY, emptyTuple);
    }

    public void reduce(Serializable key, Iterator<Map<String, Double>> values, MapReduce.ReduceEmitter<Serializable, Map<String, Double>> emitter) {
        HashMap<String, Double> emptyTuple = new HashMap<String, Double>(2);
        emptyTuple.put(SUM, 0.0);
        emptyTuple.put(COUNT, 0.0);
        emitter.emit((Object)key, IteratorUtils.reduce(values, emptyTuple, (a, b) -> {
            a.put(COUNT, (Double)a.get(COUNT) + (Double)b.get(COUNT));
            a.put(SUM, (Double)a.get(SUM) + (Double)b.get(SUM));
            return a;
        }));
    }

    public void combine(Serializable key, Iterator<Map<String, Double>> values, MapReduce.ReduceEmitter<Serializable, Map<String, Double>> emitter) {
        this.reduce(key, values, emitter);
    }

    public boolean doStage(MapReduce.Stage stage) {
        return true;
    }

    public Map<Serializable, Map<String, Double>> generateFinalResult(Iterator<KeyValue<Serializable, Map<String, Double>>> keyValues) {
        HashMap<Serializable, Map<String, Double>> mean = new HashMap<Serializable, Map<String, Double>>();
        keyValues.forEachRemaining(pair -> {
            Map cfr_ignored_0 = (Map)mean.put((Serializable)pair.getKey(), (Map<String, Double>)pair.getValue());
        });
        return mean;
    }
}

