/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.ResourceType;
import ai.grakn.graql.internal.analytics.GraknVertexProgram;
import ai.grakn.graql.internal.analytics.Utility;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class MedianVertexProgram
extends GraknVertexProgram<Long> {
    private static final int MAX_ITERATION = 40;
    private static final String RESOURCE_DATA_TYPE = "medianVertexProgram.resourceDataType";
    private static final String RESOURCE_TYPE = "medianVertexProgram.statisticsResourceType";
    public static final String DEGREE = "medianVertexProgram.degree";
    private static final String LABEL = "medianVertexProgram.label";
    public static final String COUNT = "medianVertexProgram.count";
    private static final String INDEX_START = "medianVertexProgram.indexStart";
    private static final String INDEX_END = "medianVertexProgram.indexEnd";
    private static final String INDEX_MEDIAN = "medianVertexProgram.indexMedian";
    public static final String MEDIAN = "medianVertexProgram.median";
    private static final String PIVOT = "medianVertexProgram.pivot";
    private static final String PIVOT_POSITIVE = "medianVertexProgram.pivotPositive";
    private static final String PIVOT_NEGATIVE = "medianVertexProgram.pivotNegative";
    private static final String POSITIVE_COUNT = "medianVertexProgram.positiveCount";
    private static final String NEGATIVE_COUNT = "medianVertexProgram.negativeCount";
    private static final String FOUND = "medianVertexProgram.found";
    private static final String LABEL_SELECTED = "medianVertexProgram.labelSelected";
    private static final Set<String> ELEMENT_COMPUTE_KEYS = Sets.newHashSet((Object[])new String[]{"medianVertexProgram.degree", "medianVertexProgram.label"});
    private static final Set<String> MEMORY_COMPUTE_KEYS = Sets.newHashSet((Object[])new String[]{"medianVertexProgram.count", "medianVertexProgram.median", "medianVertexProgram.found", "medianVertexProgram.indexStart", "medianVertexProgram.indexEnd", "medianVertexProgram.indexMedian", "medianVertexProgram.pivot", "medianVertexProgram.pivotPositive", "medianVertexProgram.pivotNegative", "medianVertexProgram.positiveCount", "medianVertexProgram.negativeCount", "medianVertexProgram.labelSelected"});
    private Set<String> statisticsResourceTypes = new HashSet<String>();

    public MedianVertexProgram() {
    }

    public MedianVertexProgram(Set<String> selectedTypes, Set<String> statisticsResourceTypes, String resourceDataType) {
        this.selectedTypes = selectedTypes;
        this.statisticsResourceTypes = statisticsResourceTypes;
        String resourceDataTypeValue = resourceDataType.equals(ResourceType.DataType.LONG.getName()) ? Schema.ConceptProperty.VALUE_LONG.name() : Schema.ConceptProperty.VALUE_DOUBLE.name();
        this.persistentProperties.put(RESOURCE_DATA_TYPE, resourceDataTypeValue);
    }

    public Set<String> getElementComputeKeys() {
        return ELEMENT_COMPUTE_KEYS;
    }

    public Set<String> getMemoryComputeKeys() {
        return MEMORY_COMPUTE_KEYS;
    }

    @Override
    public Set<MessageScope> getMessageScopes(Memory memory) {
        if (memory.getIteration() < 3) {
            return messageScopeSet;
        }
        return Collections.emptySet();
    }

    @Override
    public void storeState(Configuration configuration) {
        super.storeState(configuration);
        this.statisticsResourceTypes.forEach(typeId -> configuration.addProperty("medianVertexProgram.statisticsResourceType." + typeId, typeId));
    }

    @Override
    public void loadState(Graph graph, Configuration configuration) {
        super.loadState(graph, configuration);
        configuration.subset(RESOURCE_TYPE).getKeys().forEachRemaining(key -> this.statisticsResourceTypes.add((String)configuration.getProperty("medianVertexProgram.statisticsResourceType." + key)));
    }

    @Override
    public void setup(Memory memory) {
        LOGGER.debug("MedianVertexProgram Started !!!!!!!!");
        memory.set(COUNT, (Object)0L);
        memory.set(LABEL_SELECTED, (Object)memory.getIteration());
        memory.set(NEGATIVE_COUNT, (Object)0L);
        memory.set(POSITIVE_COUNT, (Object)0L);
        memory.set(FOUND, (Object)false);
        if (this.persistentProperties.get(RESOURCE_DATA_TYPE).equals(Schema.ConceptProperty.VALUE_LONG.name())) {
            memory.set(MEDIAN, (Object)0L);
            memory.set(PIVOT, (Object)0L);
            memory.set(PIVOT_NEGATIVE, (Object)0L);
            memory.set(PIVOT_POSITIVE, (Object)0L);
        } else {
            memory.set(MEDIAN, (Object)0.0);
            memory.set(PIVOT, (Object)0.0);
            memory.set(PIVOT_NEGATIVE, (Object)0.0);
            memory.set(PIVOT_POSITIVE, (Object)0.0);
        }
    }

    @Override
    public void safeExecute(Vertex vertex, Messenger<Long> messenger, Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                if (!this.selectedTypes.contains(Utility.getVertexType(vertex))) break;
                this.degreeStep0(vertex, messenger);
                break;
            }
            case 1: {
                if (!vertex.label().equals(Schema.BaseType.CASTING.name())) break;
                this.degreeStep1(messenger);
                break;
            }
            case 2: {
                if (!this.statisticsResourceTypes.contains(Utility.getVertexType(vertex))) break;
                long edgeCount = this.getEdgeCount(messenger);
                vertex.property(DEGREE, (Object)edgeCount);
                if (edgeCount <= 0L) break;
                memory.set(PIVOT, vertex.value((String)this.persistentProperties.get(RESOURCE_DATA_TYPE)));
                memory.incr(COUNT, edgeCount);
                break;
            }
            case 3: {
                if (!this.statisticsResourceTypes.contains(Utility.getVertexType(vertex)) || (Long)vertex.value(DEGREE) <= 0L) break;
                Number value = (Number)vertex.value((String)this.persistentProperties.get(RESOURCE_DATA_TYPE));
                if (value.doubleValue() < ((Number)memory.get(PIVOT)).doubleValue()) {
                    vertex.property(LABEL, (Object)(-memory.getIteration()));
                    memory.incr(NEGATIVE_COUNT, ((Long)vertex.value(DEGREE)).longValue());
                    memory.set(PIVOT_NEGATIVE, (Object)value);
                    break;
                }
                if (value.doubleValue() > ((Number)memory.get(PIVOT)).doubleValue()) {
                    vertex.property(LABEL, (Object)memory.getIteration());
                    memory.incr(POSITIVE_COUNT, ((Long)vertex.value(DEGREE)).longValue());
                    memory.set(PIVOT_POSITIVE, (Object)value);
                    break;
                }
                vertex.property(LABEL, (Object)0);
                break;
            }
            default: {
                if (!this.statisticsResourceTypes.contains(Utility.getVertexType(vertex)) || (Long)vertex.value(DEGREE) <= 0L || ((Integer)vertex.value(LABEL)).intValue() != ((Integer)memory.get(LABEL_SELECTED)).intValue()) break;
                Number value = (Number)vertex.value((String)this.persistentProperties.get(RESOURCE_DATA_TYPE));
                if (value.doubleValue() < ((Number)memory.get(PIVOT)).doubleValue()) {
                    vertex.property(LABEL, (Object)(-memory.getIteration()));
                    memory.incr(NEGATIVE_COUNT, ((Long)vertex.value(DEGREE)).longValue());
                    memory.set(PIVOT_NEGATIVE, (Object)value);
                    break;
                }
                if (!(value.doubleValue() > ((Number)memory.get(PIVOT)).doubleValue())) break;
                vertex.property(LABEL, (Object)memory.getIteration());
                memory.incr(POSITIVE_COUNT, ((Long)vertex.value(DEGREE)).longValue());
                memory.set(PIVOT_POSITIVE, (Object)value);
            }
        }
    }

    public boolean terminate(Memory memory) {
        LOGGER.debug("Finished Iteration " + memory.getIteration());
        if (memory.getIteration() == 2) {
            memory.set(INDEX_START, (Object)0L);
            memory.set(INDEX_END, (Object)((Long)memory.get(COUNT) - 1L));
            memory.set(INDEX_MEDIAN, (Object)(((Long)memory.get(COUNT) - 1L) / 2L));
            LOGGER.debug("count: " + memory.get(COUNT));
            LOGGER.debug("first pivot: " + memory.get(PIVOT));
        } else if (memory.getIteration() > 2) {
            long indexNegativeEnd = (Long)memory.get(INDEX_START) + (Long)memory.get(NEGATIVE_COUNT) - 1L;
            long indexPositiveStart = (Long)memory.get(INDEX_END) - (Long)memory.get(POSITIVE_COUNT) + 1L;
            LOGGER.debug("pivot: " + memory.get(PIVOT));
            LOGGER.debug(memory.get(INDEX_START) + ", " + indexNegativeEnd);
            LOGGER.debug(indexPositiveStart + ", " + memory.get(INDEX_END));
            LOGGER.debug("negative count: " + memory.get(NEGATIVE_COUNT));
            LOGGER.debug("positive count: " + memory.get(POSITIVE_COUNT));
            LOGGER.debug("negative pivot: " + memory.get(PIVOT_NEGATIVE));
            LOGGER.debug("positive pivot: " + memory.get(PIVOT_POSITIVE));
            if (indexNegativeEnd < (Long)memory.get(INDEX_MEDIAN)) {
                if (indexPositiveStart > (Long)memory.get(INDEX_MEDIAN)) {
                    memory.set(FOUND, (Object)true);
                    LOGGER.debug("FOUND IT!!!");
                } else {
                    memory.set(INDEX_START, (Object)indexPositiveStart);
                    memory.set(PIVOT, memory.get(PIVOT_POSITIVE));
                    memory.set(LABEL_SELECTED, (Object)memory.getIteration());
                    LOGGER.debug("new pivot: " + memory.get(PIVOT));
                }
            } else {
                memory.set(INDEX_END, (Object)indexNegativeEnd);
                memory.set(PIVOT, memory.get(PIVOT_NEGATIVE));
                memory.set(LABEL_SELECTED, (Object)(-memory.getIteration()));
                LOGGER.debug("new pivot: " + memory.get(PIVOT));
            }
            memory.set(MEDIAN, memory.get(PIVOT));
            memory.set(POSITIVE_COUNT, (Object)0L);
            memory.set(NEGATIVE_COUNT, (Object)0L);
        }
        return (Boolean)memory.get(FOUND) != false || memory.getIteration() >= 40;
    }
}

