/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.ResourceType;
import ai.grakn.graql.internal.analytics.GraknMapReduce;
import ai.grakn.graql.internal.analytics.Utility;
import ai.grakn.util.Schema;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class SumMapReduce
extends GraknMapReduce<Number> {
    public static final String MEMORY_KEY = "sum";
    private static final String RESOURCE_DATA_TYPE_KEY = "RESOURCE_DATA_TYPE_KEY";

    public SumMapReduce() {
    }

    public SumMapReduce(Set<String> selectedTypes, String resourceDataType) {
        this.selectedTypes = selectedTypes;
        this.persistentProperties.put(RESOURCE_DATA_TYPE_KEY, resourceDataType);
    }

    @Override
    public void safeMap(Vertex vertex, MapReduce.MapEmitter<Serializable, Number> emitter) {
        if (this.persistentProperties.get(RESOURCE_DATA_TYPE_KEY).equals(ResourceType.DataType.LONG.getName())) {
            if (this.selectedTypes.contains(Utility.getVertexType(vertex)) && (Long)vertex.value("medianVertexProgram.degree") > 0L) {
                emitter.emit((Object)MEMORY_KEY, (Object)((Long)vertex.value(Schema.ConceptProperty.VALUE_LONG.name()) * (Long)vertex.value("medianVertexProgram.degree")));
                return;
            }
            emitter.emit((Object)MEMORY_KEY, (Object)0L);
        } else {
            if (this.selectedTypes.contains(Utility.getVertexType(vertex)) && (Long)vertex.value("medianVertexProgram.degree") > 0L) {
                emitter.emit((Object)MEMORY_KEY, (Object)((Double)vertex.value(Schema.ConceptProperty.VALUE_DOUBLE.name()) * (double)((Long)vertex.value("medianVertexProgram.degree")).longValue()));
                return;
            }
            emitter.emit((Object)MEMORY_KEY, (Object)0.0);
        }
    }

    public void reduce(Serializable key, Iterator<Number> values, MapReduce.ReduceEmitter<Serializable, Number> emitter) {
        if (this.persistentProperties.get(RESOURCE_DATA_TYPE_KEY).equals(ResourceType.DataType.LONG.getName())) {
            emitter.emit((Object)key, IteratorUtils.reduce(values, (Object)0L, (a, b) -> a.longValue() + b.longValue()));
        } else {
            emitter.emit((Object)key, IteratorUtils.reduce(values, (Object)0.0, (a, b) -> a.doubleValue() + b.doubleValue()));
        }
    }

    public void combine(Serializable key, Iterator<Number> values, MapReduce.ReduceEmitter<Serializable, Number> emitter) {
        this.reduce(key, values, emitter);
    }

    public boolean doStage(MapReduce.Stage stage) {
        return true;
    }

    public Map<Serializable, Number> generateFinalResult(Iterator<KeyValue<Serializable, Number>> keyValues) {
        HashMap<Serializable, Number> sum = new HashMap<Serializable, Number>();
        keyValues.forEachRemaining(pair -> {
            Number cfr_ignored_0 = (Number)sum.put((Serializable)pair.getKey(), (Number)pair.getValue());
        });
        return sum;
    }
}

