/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin;

import ai.grakn.GraknGraph;
import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.internal.gremlin.ConjunctionQuery;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.javatuples.Pair;

public class GraqlTraversal {
    private final ImmutableSet<ImmutableList<Fragment>> fragments;
    private static final long NUM_VERTICES_ESTIMATE = 10000L;
    private static final long MAX_TRAVERSAL_ATTEMPTS = 1000L;

    private GraqlTraversal(Set<? extends List<Fragment>> fragments) {
        this.fragments = fragments.stream().map(ImmutableList::copyOf).collect(CommonUtil.toImmutableSet());
    }

    public static GraqlTraversal create(Set<? extends List<Fragment>> fragments) {
        return new GraqlTraversal(fragments);
    }

    public static GraqlTraversal semiOptimal(PatternAdmin pattern) {
        Set patterns = pattern.getDisjunctiveNormalForm().getPatterns();
        Set fragments = (Set)patterns.stream().map(ConjunctionQuery::new).map(GraqlTraversal::semiOptimalConjunction).collect(CommonUtil.toImmutableSet());
        return GraqlTraversal.create(fragments);
    }

    private static List<Fragment> semiOptimalConjunction(ConjunctionQuery query) {
        HashSet fragmentSets = Sets.newHashSet(query.getEquivalentFragmentSets());
        HashSet<VarName> names = new HashSet<VarName>();
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        long numFragments = GraqlTraversal.fragments(fragmentSets).count();
        long depth = 1L;
        for (long numTraversalAttempts = numFragments; numFragments > 0L && numTraversalAttempts < 1000L; numTraversalAttempts *= numFragments, --numFragments) {
            ++depth;
        }
        double cost = 1.0;
        while (!fragmentSets.isEmpty()) {
            Pair<Double, List<Fragment>> pair = GraqlTraversal.findPlan(fragmentSets, names, cost, depth);
            cost = (Double)pair.getValue0();
            List newFragments = Lists.reverse((List)((List)pair.getValue1()));
            if (newFragments.isEmpty()) {
                throw new RuntimeException(ErrorMessage.FAILED_TO_BUILD_TRAVERSAL.getMessage(new Object[0]));
            }
            newFragments.forEach(fragment -> {
                fragmentSets.remove(fragment.getEquivalentFragmentSet());
                fragment.getVariableNames().forEach(names::add);
            });
            fragments.addAll(newFragments);
        }
        return fragments;
    }

    private static Pair<Double, List<Fragment>> findPlan(Set<EquivalentFragmentSet> fragmentSets, Set<VarName> names, double cost, long depth) {
        Pair baseCase = Pair.with((Object)cost, (Object)Lists.newArrayList());
        if (depth == 0L) {
            return baseCase;
        }
        Comparator<Pair> byCost = Comparator.comparing(Pair::getValue0);
        return GraqlTraversal.fragments(fragmentSets).filter(fragment -> names.containsAll(fragment.getDependencies())).map(fragment -> GraqlTraversal.findPlanWithFragment(fragment, fragmentSets, names, cost, depth)).min(byCost).orElse(baseCase);
    }

    private static Pair<Double, List<Fragment>> findPlanWithFragment(Fragment fragment, Set<EquivalentFragmentSet> fragmentSets, Set<VarName> names, double cost, long depth) {
        double newCost = GraqlTraversal.fragmentCost(fragment, cost, names);
        EquivalentFragmentSet fragmentSet = fragment.getEquivalentFragmentSet();
        Sets.SetView newFragmentSets = Sets.difference(fragmentSets, (Set)ImmutableSet.of((Object)fragmentSet));
        Sets.SetView newNames = Sets.union(names, fragment.getVariableNames().collect(Collectors.toSet()));
        Pair<Double, List<Fragment>> pair = GraqlTraversal.findPlan((Set<EquivalentFragmentSet>)newFragmentSets, (Set<VarName>)newNames, newCost, depth - 1L);
        ((List)pair.getValue1()).add(fragment);
        return pair.setAt0((Object)((Double)pair.getValue0() + newCost));
    }

    public GraphTraversal<Vertex, Map<String, Vertex>> getGraphTraversal(GraknGraph graph) {
        Traversal[] traversals = (Traversal[])this.fragments.stream().map(list -> this.getConjunctionTraversal(graph, (ImmutableList<Fragment>)list)).toArray(Traversal[]::new);
        return graph.admin().getTinkerTraversal().limit(1L).union(traversals);
    }

    private GraphTraversal<Vertex, Map<String, Vertex>> getConjunctionTraversal(GraknGraph graph, ImmutableList<Fragment> fragmentList) {
        GraphTraversal traversal = graph.admin().getTinkerTraversal();
        HashSet<VarName> foundNames = new HashSet<VarName>();
        VarName currentName = null;
        for (Fragment fragment : fragmentList) {
            this.applyFragment(fragment, (GraphTraversal<Vertex, Vertex>)traversal, currentName, foundNames);
            currentName = fragment.getEnd().orElse(fragment.getStart());
        }
        String[] traversalNames = (String[])foundNames.stream().map(VarName::getValue).toArray(String[]::new);
        return traversal.select(traversalNames[0], traversalNames[0], traversalNames);
    }

    private void applyFragment(Fragment fragment, GraphTraversal<Vertex, Vertex> traversal, VarName currentName, Set<VarName> names) {
        VarName start = fragment.getStart();
        if (currentName != null) {
            if (!currentName.equals(start)) {
                if (names.contains(start)) {
                    traversal.select(start.getValue());
                } else {
                    traversal.V(new Object[0]).as(start.getValue(), new String[0]);
                }
            }
        } else {
            traversal.as(start.getValue(), new String[0]);
        }
        names.add(start);
        fragment.applyTraversal(traversal);
        fragment.getEnd().ifPresent(end -> {
            if (!names.contains(end)) {
                names.add((VarName)end);
                traversal.as(end.getValue(), new String[0]);
            } else {
                traversal.where(P.eq((Object)end.getValue()));
            }
        });
    }

    public double getComplexity() {
        double totalCost = 0.0;
        for (List list : this.fragments) {
            HashSet<VarName> names = new HashSet<VarName>();
            double cost = 1.0;
            double listCost = 0.0;
            for (Fragment fragment : list) {
                cost = GraqlTraversal.fragmentCost(fragment, cost, names);
                fragment.getVariableNames().forEach(names::add);
                listCost += cost;
            }
            totalCost += listCost;
        }
        return totalCost;
    }

    private static double fragmentCost(Fragment fragment, double previousCost, Set<VarName> names) {
        if (names.contains(fragment.getStart())) {
            return fragment.fragmentCost(previousCost);
        }
        return fragment.fragmentCost(10000.0) * previousCost + 1.0;
    }

    private static Stream<Fragment> fragments(Set<EquivalentFragmentSet> fragmentSets) {
        return fragmentSets.stream().flatMap(EquivalentFragmentSet::getFragments);
    }

    public String toString() {
        return "{" + this.fragments.stream().map(list -> {
            StringBuilder sb = new StringBuilder();
            VarName currentName = null;
            for (Fragment fragment : list) {
                if (!fragment.getStart().equals(currentName)) {
                    if (currentName != null) {
                        sb.append(" ");
                    }
                    sb.append(fragment.getStart().shortName());
                    currentName = fragment.getStart();
                }
                sb.append(fragment.getName());
                Optional<VarName> end = fragment.getEnd();
                if (!end.isPresent()) continue;
                sb.append(end.get().shortName());
                currentName = end.get();
            }
            return sb.toString();
        }).collect(Collectors.joining(", ")) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraqlTraversal that = (GraqlTraversal)o;
        return this.fragments.equals(that.fragments);
    }

    public int hashCode() {
        return this.fragments.hashCode();
    }
}

