/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin;

import ai.grakn.graql.VarName;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.fragment.Fragments;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ShortcutTraversal {
    private final List<Optional<String>> roletypes = new ArrayList<Optional<String>>();
    private final List<VarName> roleplayers = new ArrayList<VarName>();
    private boolean valid = true;
    private Optional<String> type = Optional.empty();
    private EquivalentFragmentSet equivalentFragmentSet = null;

    boolean isValid() {
        return this.valid && this.roleplayers.size() == 2;
    }

    public void setInvalid() {
        this.valid = false;
    }

    EquivalentFragmentSet getEquivalentFragmentSet() {
        if (this.equivalentFragmentSet == null) {
            this.makeEquivalentFragmentSet();
        }
        return this.equivalentFragmentSet;
    }

    private void makeEquivalentFragmentSet() {
        Optional<String> roleA = this.roletypes.get(0);
        VarName playerA = this.roleplayers.get(0);
        Optional<String> roleB = this.roletypes.get(1);
        VarName playerB = this.roleplayers.get(1);
        this.equivalentFragmentSet = EquivalentFragmentSet.create(Fragments.shortcut(this.type, roleA, roleB, playerA, playerB), Fragments.shortcut(this.type, roleB, roleA, playerB, playerA));
    }

    public void setType(String type) {
        if (!this.type.isPresent()) {
            this.type = Optional.of(type);
        } else {
            this.setInvalid();
        }
    }

    public void addRel(VarName roleplayer) {
        this.roletypes.add(Optional.empty());
        this.roleplayers.add(roleplayer);
    }

    public void addRel(String roletype, VarName roleplayer) {
        this.roletypes.add(Optional.of(roletype));
        this.roleplayers.add(roleplayer);
    }
}

