/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.fragment;

import ai.grakn.concept.ResourceType;
import ai.grakn.graql.VarName;
import ai.grakn.graql.internal.gremlin.fragment.AbstractFragment;
import ai.grakn.util.Schema;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class DataTypeFragment
extends AbstractFragment {
    private final ResourceType.DataType dataType;

    DataTypeFragment(VarName start, ResourceType.DataType dataType) {
        super(start);
        this.dataType = dataType;
    }

    @Override
    public void applyTraversal(GraphTraversal<Vertex, Vertex> traversal) {
        traversal.has(Schema.ConceptProperty.DATA_TYPE.name(), (Object)this.dataType.getName());
    }

    @Override
    public String getName() {
        return "[datatype:" + this.dataType.getName() + "]";
    }

    @Override
    public double fragmentCost(double previousCost) {
        return previousCost / (double)ResourceType.DataType.SUPPORTED_TYPES.size();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataTypeFragment that = (DataTypeFragment)o;
        return this.dataType != null ? this.dataType.equals(that.dataType) : that.dataType == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
        return result;
    }
}

