/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.fragment;

import ai.grakn.graql.VarName;
import ai.grakn.graql.internal.gremlin.fragment.AbstractFragment;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class DistinctCastingFragment
extends AbstractFragment {
    private final VarName otherCastingName;

    DistinctCastingFragment(VarName start, VarName otherCastingName) {
        super(start);
        this.otherCastingName = otherCastingName;
    }

    @Override
    public void applyTraversal(GraphTraversal<Vertex, Vertex> traversal) {
        traversal.where(P.neq((Object)this.otherCastingName.getValue()));
    }

    @Override
    public Set<VarName> getDependencies() {
        return ImmutableSet.of((Object)this.otherCastingName);
    }

    @Override
    public String getName() {
        return "[distinct-casting:" + this.otherCastingName.shortName() + "]";
    }

    @Override
    public double fragmentCost(double previousCost) {
        return previousCost / 2.0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DistinctCastingFragment that = (DistinctCastingFragment)o;
        return this.otherCastingName != null ? this.otherCastingName.equals(that.otherCastingName) : that.otherCastingName == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.otherCastingName != null ? this.otherCastingName.hashCode() : 0);
        return result;
    }
}

