/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.fragment;

import ai.grakn.graql.VarName;
import ai.grakn.graql.internal.gremlin.fragment.AbstractFragment;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.Schema;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class RegexFragment
extends AbstractFragment {
    private final String regex;

    RegexFragment(VarName start, String regex) {
        super(start);
        this.regex = regex;
    }

    @Override
    public void applyTraversal(GraphTraversal<Vertex, Vertex> traversal) {
        traversal.has(Schema.ConceptProperty.REGEX.name(), (Object)this.regex);
    }

    @Override
    public String getName() {
        return "[regex:" + StringConverter.valueToString(this.regex) + "]";
    }

    @Override
    public double fragmentCost(double previousCost) {
        return previousCost;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegexFragment that = (RegexFragment)o;
        return this.regex != null ? this.regex.equals(that.regex) : that.regex == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.regex != null ? this.regex.hashCode() : 0);
        return result;
    }
}

