/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.fragment;

import ai.grakn.graql.VarName;
import ai.grakn.graql.internal.gremlin.fragment.AbstractFragment;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.Schema;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class ShortcutFragment
extends AbstractFragment {
    private final Optional<String> relationType;
    private final Optional<String> roleStart;
    private final Optional<String> roleEnd;

    ShortcutFragment(Optional<String> relationType, Optional<String> roleStart, Optional<String> roleEnd, VarName start, VarName end) {
        super(start, end);
        this.relationType = relationType;
        this.roleStart = roleStart;
        this.roleEnd = roleEnd;
    }

    @Override
    public void applyTraversal(GraphTraversal<Vertex, Vertex> traversal) {
        GraphTraversal edgeTraversal = traversal.outE(new String[]{Schema.EdgeLabel.SHORTCUT.getLabel()});
        this.roleStart.ifPresent(rs -> edgeTraversal.has(Schema.EdgeProperty.FROM_ROLE_NAME.name(), rs));
        this.roleEnd.ifPresent(re -> edgeTraversal.has(Schema.EdgeProperty.TO_ROLE_NAME.name(), re));
        this.relationType.ifPresent(rt -> edgeTraversal.has(Schema.EdgeProperty.RELATION_TYPE_NAME.name(), rt));
        edgeTraversal.inV();
    }

    @Override
    public String getName() {
        String start = this.roleStart.map(rs -> StringConverter.idToString(rs) + " ").orElse("");
        String type = this.relationType.map(rt -> ":" + StringConverter.idToString(rt)).orElse("");
        String end = this.roleEnd.map(re -> " " + StringConverter.idToString(re)).orElse("");
        return "-[" + start + "shortcut" + type + end + "]->";
    }

    @Override
    public double fragmentCost(double previousCost) {
        return previousCost * 10.0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ShortcutFragment that = (ShortcutFragment)o;
        if (this.relationType != null ? !this.relationType.equals(that.relationType) : that.relationType != null) {
            return false;
        }
        if (this.roleStart != null ? !this.roleStart.equals(that.roleStart) : that.roleStart != null) {
            return false;
        }
        return this.roleEnd != null ? this.roleEnd.equals(that.roleEnd) : that.roleEnd == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.relationType != null ? this.relationType.hashCode() : 0);
        result = 31 * result + (this.roleStart != null ? this.roleStart.hashCode() : 0);
        result = 31 * result + (this.roleEnd != null ? this.roleEnd.hashCode() : 0);
        return result;
    }
}

