/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.parser;

import ai.grakn.graql.Aggregate;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Query;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.graql.VarName;
import ai.grakn.graql.internal.antlr.GraqlBaseVisitor;
import ai.grakn.graql.internal.antlr.GraqlLexer;
import ai.grakn.graql.internal.antlr.GraqlParser;
import ai.grakn.graql.internal.parser.GraqlErrorListener;
import ai.grakn.graql.internal.parser.QueryVisitor;
import ai.grakn.graql.internal.query.aggregate.Aggregates;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.antlr.v4.runtime.UnbufferedTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class QueryParser {
    private final QueryBuilder queryBuilder;
    private final Map<String, Function<List<Object>, Aggregate>> aggregateMethods = new HashMap<String, Function<List<Object>, Aggregate>>();

    private QueryParser(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        this.registerDefaultAggregates();
    }

    public static QueryParser create(QueryBuilder queryBuilder) {
        return new QueryParser(queryBuilder);
    }

    public void registerAggregate(String name, Function<List<Object>, Aggregate> aggregateMethod) {
        this.aggregateMethods.put(name, aggregateMethod);
    }

    public <T extends Query<?>> T parseQuery(String queryString) {
        return (T)this.parseQueryFragment(GraqlParser::queryEOF, QueryVisitor::visitQueryEOF, queryString);
    }

    public List<Query<?>> parseList(String queryString) {
        return this.parseQueryFragment(GraqlParser::queryList, QueryVisitor::visitQueryList, queryString);
    }

    public List<Pattern> parsePatterns(String patternsString) {
        return this.parseQueryFragment(GraqlParser::patterns, QueryVisitor::visitPatterns, patternsString);
    }

    public Pattern parsePattern(String patternString) {
        return this.parseQueryFragment(GraqlParser::pattern, QueryVisitor::visitPattern, patternString);
    }

    public Stream<Object> parseBatchLoad(InputStream inputStream) {
        GraqlLexer lexer = new GraqlLexer((CharStream)new UnbufferedCharStream(inputStream));
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        final UnbufferedTokenStream tokens = new UnbufferedTokenStream((TokenSource)lexer);
        Iterable iterable = () -> new Iterator<Object>(){
            private Object pattern = null;

            private Optional<Object> getNext() {
                if (this.pattern == null) {
                    if (tokens.get(tokens.index()).getType() == -1) {
                        return Optional.empty();
                    }
                    this.pattern = QueryParser.this.parseQueryFragment(GraqlParser::batchPattern, QueryVisitor::visitBatchPattern, (TokenStream)tokens);
                }
                return Optional.of(this.pattern);
            }

            @Override
            public boolean hasNext() {
                return this.getNext().isPresent();
            }

            @Override
            public Object next() {
                Optional<Object> result = this.getNext();
                this.pattern = null;
                return result.orElseThrow(NoSuchElementException::new);
            }
        };
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public Stream<Pattern> parsePatterns(InputStream inputStream) {
        GraqlLexer lexer = new GraqlLexer((CharStream)new UnbufferedCharStream(inputStream));
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        final UnbufferedTokenStream tokens = new UnbufferedTokenStream((TokenSource)lexer);
        this.parseQueryFragment(GraqlParser::insert, GraqlBaseVisitor::visitInsert, (TokenStream)tokens);
        Iterable iterable = () -> new Iterator<Pattern>(){
            private Pattern pattern = null;

            private Optional<Pattern> getNext() {
                if (this.pattern == null) {
                    if (tokens.get(tokens.index()).getType() == -1) {
                        return Optional.empty();
                    }
                    this.pattern = (Pattern)QueryParser.this.parseQueryFragment(GraqlParser::patternSep, QueryVisitor::visitPatternSep, (TokenStream)tokens);
                }
                return Optional.of(this.pattern);
            }

            @Override
            public boolean hasNext() {
                return this.getNext().isPresent();
            }

            @Override
            public Pattern next() {
                Optional<Pattern> result = this.getNext();
                this.pattern = null;
                return result.orElseThrow(NoSuchElementException::new);
            }
        };
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    private <T, S extends ParseTree> T parseQueryFragment(Function<GraqlParser, S> parseRule, BiFunction<QueryVisitor, S, T> visit, String queryString) {
        GraqlLexer lexer = this.getLexer(queryString);
        GraqlErrorListener errorListener = new GraqlErrorListener(queryString);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        return this.parseQueryFragment(parseRule, visit, errorListener, (TokenStream)tokens);
    }

    private <T, S extends ParseTree> T parseQueryFragment(Function<GraqlParser, S> parseRule, BiFunction<QueryVisitor, S, T> visit, TokenStream tokens) {
        GraqlErrorListener errorListener = new GraqlErrorListener(tokens.getText());
        return this.parseQueryFragment(parseRule, visit, errorListener, tokens);
    }

    private <T, S extends ParseTree> T parseQueryFragment(Function<GraqlParser, S> parseRule, BiFunction<QueryVisitor, S, T> visit, GraqlErrorListener errorListener, TokenStream tokens) {
        GraqlParser parser = new GraqlParser(tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        ParseTree tree = (ParseTree)parseRule.apply(parser);
        if (errorListener.hasErrors()) {
            throw new IllegalArgumentException(errorListener.toString());
        }
        return visit.apply(this.getQueryVisitor(), tree);
    }

    private GraqlLexer getLexer(String queryString) {
        ANTLRInputStream input = new ANTLRInputStream(queryString);
        return new GraqlLexer((CharStream)input);
    }

    private QueryVisitor getQueryVisitor() {
        ImmutableMap immutableAggregates = ImmutableMap.copyOf(this.aggregateMethods);
        return new QueryVisitor((ImmutableMap<String, Function<List<Object>, Aggregate>>)immutableAggregates, this.queryBuilder);
    }

    private void registerDefaultAggregates() {
        this.registerAggregate("count", args -> Graql.count());
        this.registerAggregate("sum", args -> Graql.sum((String)args.get(0)));
        this.registerAggregate("max", args -> Graql.max((String)args.get(0)));
        this.registerAggregate("min", args -> Graql.min((String)args.get(0)));
        this.registerAggregate("average", args -> Graql.average((String)args.get(0)));
        this.registerAggregate("median", args -> Graql.median((String)args.get(0)));
        this.registerAggregate("group", args -> {
            if (args.size() < 2) {
                return Aggregates.group((VarName)args.get(0));
            }
            return Aggregates.group((VarName)args.get(0), (Aggregate)args.get(1));
        });
    }
}

