/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern;

import ai.grakn.concept.ConceptId;
import ai.grakn.concept.ResourceType;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.ValuePredicate;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.Disjunction;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.RelationPlayer;
import ai.grakn.graql.admin.UniqueVarProperty;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.pattern.RelationPlayerImpl;
import ai.grakn.graql.internal.pattern.VarNameImpl;
import ai.grakn.graql.internal.pattern.property.DataTypeProperty;
import ai.grakn.graql.internal.pattern.property.HasResourceProperty;
import ai.grakn.graql.internal.pattern.property.HasResourceTypeProperty;
import ai.grakn.graql.internal.pattern.property.HasRoleProperty;
import ai.grakn.graql.internal.pattern.property.HasScopeProperty;
import ai.grakn.graql.internal.pattern.property.IdProperty;
import ai.grakn.graql.internal.pattern.property.IsAbstractProperty;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.pattern.property.LhsProperty;
import ai.grakn.graql.internal.pattern.property.NameProperty;
import ai.grakn.graql.internal.pattern.property.NeqProperty;
import ai.grakn.graql.internal.pattern.property.PlaysRoleProperty;
import ai.grakn.graql.internal.pattern.property.RegexProperty;
import ai.grakn.graql.internal.pattern.property.RelationProperty;
import ai.grakn.graql.internal.pattern.property.RhsProperty;
import ai.grakn.graql.internal.pattern.property.SubProperty;
import ai.grakn.graql.internal.pattern.property.ValueFlagProperty;
import ai.grakn.graql.internal.pattern.property.ValueProperty;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableMultiset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class VarImpl
implements VarAdmin {
    private final Set<VarProperty> properties = new HashSet<VarProperty>();
    private VarName name;
    private final boolean userDefinedName;

    VarImpl() {
        this.name = new VarNameImpl();
        this.userDefinedName = false;
    }

    VarImpl(VarName name) {
        this.name = name;
        this.userDefinedName = true;
    }

    VarImpl(Collection<VarAdmin> vars) {
        VarAdmin first = vars.iterator().next();
        this.name = first.getVarName();
        this.userDefinedName = first.isUserDefinedName();
        for (VarAdmin var : vars) {
            if (var.isUserDefinedName()) {
                this.name = var.getVarName();
            }
            var.getProperties().forEach(this::addProperty);
        }
    }

    private VarImpl(VarAdmin var) {
        this.name = var.getVarName();
        this.userDefinedName = var.isUserDefinedName();
        var.getProperties().forEach(this::addProperty);
    }

    public Var id(ConceptId id) {
        return this.addProperty(new IdProperty(id));
    }

    public Var name(String name) {
        return this.addProperty(new NameProperty(name));
    }

    public Var value() {
        return this.addProperty(new ValueFlagProperty());
    }

    public Var value(Object value) {
        return this.value(Graql.eq(value));
    }

    public Var value(ValuePredicate predicate) {
        return this.addProperty(new ValueProperty(predicate.admin()));
    }

    public Var has(String type) {
        return this.has(type, Graql.var());
    }

    public Var has(Var var) {
        return this.addProperty(new HasResourceProperty(var.admin()));
    }

    public Var has(String type, Object value) {
        return this.has(type, Graql.eq(value));
    }

    public Var has(String type, ValuePredicate predicate) {
        return this.has(type, Graql.var().value(predicate));
    }

    public Var has(String type, Var var) {
        return this.addProperty(new HasResourceProperty(type, var.admin()));
    }

    public Var isa(String type) {
        return this.isa(Graql.name(type));
    }

    public Var isa(Var type) {
        return this.addProperty(new IsaProperty(type.admin()));
    }

    public Var sub(String type) {
        return this.sub(Graql.name(type));
    }

    public Var sub(Var type) {
        return this.addProperty(new SubProperty(type.admin()));
    }

    public Var hasRole(String type) {
        return this.hasRole(Graql.name(type));
    }

    public Var hasRole(Var type) {
        return this.addProperty(new HasRoleProperty(type.admin()));
    }

    public Var playsRole(String type) {
        return this.playsRole(Graql.name(type));
    }

    public Var playsRole(Var type) {
        return this.addProperty(new PlaysRoleProperty(type.admin(), false));
    }

    public Var hasScope(Var type) {
        return this.addProperty(new HasScopeProperty(type.admin()));
    }

    public Var hasResource(String type) {
        return this.hasResource(Graql.name(type));
    }

    public Var hasResource(Var type) {
        return this.addProperty(new HasResourceTypeProperty(type.admin(), false));
    }

    public Var hasKey(String type) {
        return this.hasKey(Graql.var().name(type));
    }

    public Var hasKey(Var type) {
        return this.addProperty(new HasResourceTypeProperty(type.admin(), true));
    }

    public Var rel(String roleplayer) {
        return this.rel(Graql.var(roleplayer));
    }

    public Var rel(Var roleplayer) {
        return this.addCasting(new RelationPlayerImpl(roleplayer.admin()));
    }

    public Var rel(String roletype, String roleplayer) {
        return this.rel(Graql.name(roletype), Graql.var(roleplayer));
    }

    public Var rel(Var roletype, String roleplayer) {
        return this.rel(roletype, Graql.var(roleplayer));
    }

    public Var rel(String roletype, Var roleplayer) {
        return this.rel(Graql.name(roletype), roleplayer);
    }

    public Var rel(Var roletype, Var roleplayer) {
        return this.addCasting(new RelationPlayerImpl(roletype.admin(), roleplayer.admin()));
    }

    public Var isAbstract() {
        return this.addProperty(new IsAbstractProperty());
    }

    public Var datatype(ResourceType.DataType<?> datatype) {
        return this.addProperty(new DataTypeProperty(Objects.requireNonNull(datatype)));
    }

    public Var regex(String regex) {
        return this.addProperty(new RegexProperty(regex));
    }

    public Var lhs(Pattern lhs) {
        return this.addProperty(new LhsProperty(lhs));
    }

    public Var rhs(Pattern rhs) {
        return this.addProperty(new RhsProperty(rhs));
    }

    public Var neq(String varName) {
        return this.neq(Graql.var(varName));
    }

    public Var neq(Var var) {
        return this.addProperty(new NeqProperty(var.admin()));
    }

    public VarAdmin admin() {
        return this;
    }

    public boolean isUserDefinedName() {
        return this.userDefinedName;
    }

    public Optional<ConceptId> getId() {
        return this.getProperty(IdProperty.class).map(IdProperty::getId);
    }

    public Optional<String> getTypeName() {
        return this.getProperty(NameProperty.class).map(NameProperty::getNameValue);
    }

    public VarName getVarName() {
        return this.name;
    }

    public void setVarName(VarName name) {
        if (!this.userDefinedName) {
            throw new RuntimeException(ErrorMessage.SET_GENERATED_VARIABLE_NAME.getMessage(new Object[]{name}));
        }
        this.name = name;
    }

    public String getPrintableName() {
        if (this.userDefinedName) {
            return this.name.toString();
        }
        return this.getTypeName().map(StringConverter::idToString).orElse("'" + this.toString() + "'");
    }

    public Stream<VarProperty> getProperties() {
        return this.properties.stream();
    }

    public <T extends VarProperty> Stream<T> getProperties(Class<T> type) {
        return this.getProperties().filter(type::isInstance).map(type::cast);
    }

    public <T extends UniqueVarProperty> Optional<T> getProperty(Class<T> type) {
        return this.getProperties().filter(type::isInstance).map(type::cast).findAny();
    }

    public <T extends VarProperty> boolean hasProperty(Class<T> type) {
        return this.getProperties(type).findAny().isPresent();
    }

    public Set<VarAdmin> getInnerVars() {
        Stack<VarImpl> newVars = new Stack<VarImpl>();
        HashSet<VarAdmin> vars = new HashSet<VarAdmin>();
        newVars.add(this);
        while (!newVars.isEmpty()) {
            VarAdmin var = (VarAdmin)newVars.pop();
            vars.add(var);
            var.getProperties().flatMap(VarProperty::getInnerVars).forEach(newVars::add);
        }
        return vars;
    }

    public Set<VarAdmin> getImplicitInnerVars() {
        Stack<VarImpl> newVars = new Stack<VarImpl>();
        HashSet<VarAdmin> vars = new HashSet<VarAdmin>();
        newVars.add(this);
        while (!newVars.isEmpty()) {
            VarAdmin var = (VarAdmin)newVars.pop();
            vars.add(var);
            var.getProperties().flatMap(VarProperty::getImplicitInnerVars).forEach(newVars::add);
        }
        return vars;
    }

    public Set<String> getTypeNames() {
        return this.getProperties().flatMap(VarProperty::getTypes).map(VarAdmin::getTypeName).flatMap(CommonUtil::optionalToStream).collect(Collectors.toSet());
    }

    public String toString() {
        Set<VarAdmin> innerVars = this.getInnerVars();
        innerVars.remove(this);
        this.getProperties(HasResourceProperty.class).map(HasResourceProperty::getResource).flatMap(r -> r.getInnerVars().stream()).forEach(innerVars::remove);
        if (innerVars.stream().anyMatch(VarImpl::invalidInnerVariable)) {
            throw new UnsupportedOperationException("Graql strings cannot represent a query with inner variables");
        }
        StringBuilder builder = new StringBuilder();
        String name = this.isUserDefinedName() ? this.getPrintableName() + " " : "";
        builder.append(name);
        boolean first = true;
        for (VarProperty property : this.properties) {
            if (!first) {
                builder.append(" ");
            }
            first = false;
            property.buildString(builder);
        }
        return builder.toString();
    }

    private Var addCasting(RelationPlayer relationPlayer) {
        Optional<RelationProperty> relationProperty = this.getProperty(RelationProperty.class);
        Stream oldCastings = relationProperty.map(RelationProperty::getRelationPlayers).orElse(Stream.empty());
        ImmutableMultiset relationPlayers = Stream.concat(oldCastings, Stream.of(relationPlayer)).collect(CommonUtil.toImmutableMultiset());
        relationProperty.ifPresent(this.properties::remove);
        this.properties.add(new RelationProperty(relationPlayers));
        return this;
    }

    private static boolean invalidInnerVariable(VarAdmin var) {
        return var.getProperties().anyMatch(p -> !(p instanceof NameProperty));
    }

    private Var addProperty(VarProperty property) {
        if (property.isUnique()) {
            this.testUniqueProperty((UniqueVarProperty)property);
        }
        this.properties.add(property);
        return this;
    }

    private void testUniqueProperty(UniqueVarProperty property) {
        this.getProperty(property.getClass()).filter(other -> !other.equals(property)).ifPresent(other -> {
            String message = ErrorMessage.CONFLICTING_PROPERTIES.getMessage(new Object[]{this.getPrintableName(), property.graqlString(), other.graqlString()});
            throw new IllegalStateException(message);
        });
    }

    public Disjunction<Conjunction<VarAdmin>> getDisjunctiveNormalForm() {
        Conjunction<VarImpl> conjunction = Patterns.conjunction(Collections.singleton(this));
        return Patterns.disjunction(Collections.singleton(conjunction));
    }

    public PatternAdmin cloneMe() {
        return new VarImpl(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VarImpl var = (VarImpl)o;
        if (this.userDefinedName != var.userDefinedName) {
            return false;
        }
        if (!this.properties.equals(var.properties)) {
            return false;
        }
        return !this.userDefinedName || this.name.equals(var.name);
    }

    public int hashCode() {
        int result = this.properties.hashCode();
        if (this.userDefinedName) {
            result = 31 * result + this.name.hashCode();
        }
        result = 31 * result + (this.userDefinedName ? 1 : 0);
        return result;
    }
}

