/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.concept.ResourceType;
import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.UniqueVarProperty;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.graql.internal.gremlin.fragment.Fragments;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.pattern.property.SingleFragmentProperty;

public class DataTypeProperty
extends AbstractVarProperty
implements NamedProperty,
UniqueVarProperty,
SingleFragmentProperty {
    private final ResourceType.DataType<?> datatype;

    public DataTypeProperty(ResourceType.DataType<?> datatype) {
        this.datatype = datatype;
    }

    public ResourceType.DataType<?> getDatatype() {
        return this.datatype;
    }

    @Override
    public String getName() {
        return "datatype";
    }

    @Override
    public String getProperty() {
        if (this.datatype == ResourceType.DataType.BOOLEAN) {
            return "boolean";
        }
        if (this.datatype == ResourceType.DataType.DOUBLE) {
            return "double";
        }
        if (this.datatype == ResourceType.DataType.LONG) {
            return "long";
        }
        if (this.datatype == ResourceType.DataType.STRING) {
            return "string";
        }
        throw new RuntimeException("Unknown data type: " + this.datatype.getName());
    }

    @Override
    public Fragment getFragment(VarName start) {
        return Fragments.dataType(start, this.datatype);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTypeProperty that = (DataTypeProperty)o;
        return this.datatype.equals(that.datatype);
    }

    public int hashCode() {
        return this.datatype.hashCode();
    }
}

