/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Instance;
import ai.grakn.concept.Relation;
import ai.grakn.concept.Resource;
import ai.grakn.concept.RoleType;
import ai.grakn.graql.Graql;
import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.ValuePredicateAdmin;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.fragment.Fragments;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.pattern.property.ValueProperty;
import ai.grakn.graql.internal.query.InsertQueryExecutor;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HasResourceProperty
extends AbstractVarProperty
implements NamedProperty {
    private final Optional<String> resourceType;
    private final VarAdmin resource;

    public HasResourceProperty(VarAdmin resource) {
        this.resourceType = Optional.empty();
        this.resource = resource.isa(Schema.MetaSchema.RESOURCE.getName()).admin();
    }

    public HasResourceProperty(String resourceType, VarAdmin resource) {
        this.resourceType = Optional.of(resourceType);
        this.resource = resource.isa(resourceType).admin();
    }

    public Optional<String> getType() {
        return this.resourceType;
    }

    public VarAdmin getResource() {
        return this.resource;
    }

    @Override
    public String getName() {
        return "has";
    }

    @Override
    public String getProperty() {
        Stream.Builder<String> repr = Stream.builder();
        this.resourceType.ifPresent(repr);
        if (this.resource.isUserDefinedName()) {
            repr.add(this.resource.getPrintableName());
        } else {
            this.resource.getProperties(ValueProperty.class).forEach(prop -> repr.add(prop.getPredicate().toString()));
        }
        return repr.build().collect(Collectors.joining(" "));
    }

    @Override
    public Collection<EquivalentFragmentSet> match(VarName start) {
        return Sets.newHashSet((Object[])new EquivalentFragmentSet[]{EquivalentFragmentSet.create(Fragments.shortcut(Optional.empty(), Optional.empty(), Optional.empty(), start, this.resource.getVarName()), Fragments.shortcut(Optional.empty(), Optional.empty(), Optional.empty(), this.resource.getVarName(), start))});
    }

    @Override
    public Stream<VarAdmin> getInnerVars() {
        return Stream.of(this.resource);
    }

    @Override
    void checkValidProperty(GraknGraph graph, VarAdmin var) {
        if (this.resourceType.isPresent() && graph.getResourceType(this.resourceType.get()) == null) {
            throw new IllegalStateException(ErrorMessage.MUST_BE_RESOURCE_TYPE.getMessage(new Object[]{this.resourceType}));
        }
    }

    @Override
    public void insert(InsertQueryExecutor insertQueryExecutor, Concept concept) throws IllegalStateException {
        Resource resourceConcept = insertQueryExecutor.getConcept(this.resource).asResource();
        Instance instance = concept.asInstance();
        instance.hasResource(resourceConcept);
    }

    @Override
    public void delete(GraknGraph graph, Concept concept) {
        Optional<ValuePredicateAdmin> predicate = this.resource.getProperties(ValueProperty.class).map(ValueProperty::getPredicate).findAny();
        String type = this.resourceType.orElseThrow(() -> HasResourceProperty.failDelete(this));
        RoleType owner = graph.getRoleType(Schema.Resource.HAS_RESOURCE_OWNER.getName(type));
        RoleType value = graph.getRoleType(Schema.Resource.HAS_RESOURCE_VALUE.getName(type));
        concept.asInstance().relations(new RoleType[]{owner}).stream().filter(relation -> this.testPredicate(predicate, (Relation)relation, value)).forEach(Concept::delete);
    }

    private boolean testPredicate(Optional<ValuePredicateAdmin> optPredicate, Relation relation, RoleType resourceRole) {
        Object value = ((Instance)relation.rolePlayers().get(resourceRole)).asResource().getValue();
        return optPredicate.flatMap(ValuePredicateAdmin::getPredicate).map(predicate -> predicate.test(value)).orElse(true);
    }

    @Override
    public Stream<VarAdmin> getTypes() {
        if (this.resourceType.isPresent()) {
            return Stream.of(Graql.name(this.resourceType.get()).admin());
        }
        return Stream.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HasResourceProperty that = (HasResourceProperty)o;
        return this.resourceType.equals(that.resourceType) && this.resource.equals(that.resource);
    }

    public int hashCode() {
        int result = this.resourceType.hashCode();
        result = 31 * result + this.resource.hashCode();
        return result;
    }
}

