/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.concept.Concept;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.Type;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.pattern.property.PlaysRoleProperty;
import ai.grakn.graql.internal.query.InsertQueryExecutor;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Stream;

public class HasResourceTypeProperty
extends AbstractVarProperty
implements NamedProperty {
    private final VarAdmin resourceType;
    private final VarAdmin ownerRole;
    private final VarAdmin valueRole;
    private final VarAdmin relationType;
    private final PlaysRoleProperty ownerPlaysRole;
    private final boolean required;

    public HasResourceTypeProperty(VarAdmin resourceType, boolean required) {
        this.resourceType = resourceType;
        this.required = required;
        String resourceTypeName = (String)resourceType.getTypeName().orElseThrow(() -> new IllegalStateException(ErrorMessage.NO_NAME_SPECIFIED_FOR_HAS_RESOURCE.getMessage(new Object[0])));
        this.ownerRole = Graql.name(Schema.Resource.HAS_RESOURCE_OWNER.getName(resourceTypeName)).sub(Schema.MetaSchema.ROLE.getName()).admin();
        this.valueRole = Graql.name(Schema.Resource.HAS_RESOURCE_VALUE.getName(resourceTypeName)).sub(Schema.MetaSchema.ROLE.getName()).admin();
        this.relationType = Graql.name(Schema.Resource.HAS_RESOURCE.getName(resourceTypeName)).sub(Schema.MetaSchema.RELATION.getName()).hasRole((Var)this.ownerRole).hasRole((Var)this.valueRole).admin();
        this.ownerPlaysRole = new PlaysRoleProperty(this.ownerRole, required);
    }

    public VarAdmin getResourceType() {
        return this.resourceType;
    }

    @Override
    public String getName() {
        return this.required ? "has-key" : "has-resource";
    }

    @Override
    public String getProperty() {
        return this.resourceType.getPrintableName();
    }

    @Override
    public Collection<EquivalentFragmentSet> match(VarName start) {
        HashSet<EquivalentFragmentSet> traversals = new HashSet<EquivalentFragmentSet>();
        traversals.addAll(this.ownerPlaysRole.match(start));
        PlaysRoleProperty valuePlaysRole = new PlaysRoleProperty(this.valueRole, this.required);
        traversals.addAll(valuePlaysRole.match(this.resourceType.getVarName()));
        return traversals;
    }

    @Override
    public Stream<VarAdmin> getTypes() {
        return Stream.of(this.resourceType);
    }

    @Override
    public Stream<VarAdmin> getInnerVars() {
        return Stream.of(this.resourceType);
    }

    @Override
    public Stream<VarAdmin> getImplicitInnerVars() {
        return Stream.of(this.resourceType, this.ownerRole, this.valueRole, this.relationType);
    }

    @Override
    public void insert(InsertQueryExecutor insertQueryExecutor, Concept concept) throws IllegalStateException {
        Type entityTypeConcept = concept.asType();
        ResourceType resourceTypeConcept = insertQueryExecutor.getConcept(this.resourceType).asResourceType();
        if (this.required) {
            entityTypeConcept.key(resourceTypeConcept);
        } else {
            entityTypeConcept.hasResource(resourceTypeConcept);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HasResourceTypeProperty that = (HasResourceTypeProperty)o;
        return this.resourceType.equals(that.resourceType);
    }

    public int hashCode() {
        return this.resourceType.hashCode();
    }
}

