/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.RoleType;
import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.fragment.Fragments;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.query.InsertQueryExecutor;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.stream.Stream;

public class HasRoleProperty
extends AbstractVarProperty
implements NamedProperty {
    private final VarAdmin role;

    public HasRoleProperty(VarAdmin role) {
        this.role = role;
    }

    public VarAdmin getRole() {
        return this.role;
    }

    @Override
    public String getName() {
        return "has-role";
    }

    @Override
    public String getProperty() {
        return this.role.getPrintableName();
    }

    @Override
    public Collection<EquivalentFragmentSet> match(VarName start) {
        return Sets.newHashSet((Object[])new EquivalentFragmentSet[]{EquivalentFragmentSet.create(Fragments.outHasRole(start, this.role.getVarName()), Fragments.inHasRole(this.role.getVarName(), start))});
    }

    @Override
    public Stream<VarAdmin> getTypes() {
        return Stream.of(this.role);
    }

    @Override
    public Stream<VarAdmin> getInnerVars() {
        return Stream.of(this.role);
    }

    @Override
    public void insert(InsertQueryExecutor insertQueryExecutor, Concept concept) throws IllegalStateException {
        RoleType roleType = insertQueryExecutor.getConcept(this.role).asRoleType();
        concept.asRelationType().hasRole(roleType);
    }

    @Override
    public void delete(GraknGraph graph, Concept concept) {
        String roleName = (String)this.role.getTypeName().orElseThrow(() -> HasRoleProperty.failDelete(this));
        concept.asRelationType().deleteHasRole(graph.getRoleType(roleName));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HasRoleProperty that = (HasRoleProperty)o;
        return this.role.equals(that.role);
    }

    public int hashCode() {
        return this.role.hashCode();
    }
}

