/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.RoleType;
import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.fragment.Fragments;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.query.InsertQueryExecutor;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.stream.Stream;

public class PlaysRoleProperty
extends AbstractVarProperty
implements NamedProperty {
    private final VarAdmin role;
    private final boolean required;

    public PlaysRoleProperty(VarAdmin role, boolean required) {
        this.role = role;
        this.required = required;
    }

    public VarAdmin getRole() {
        return this.role;
    }

    @Override
    public String getName() {
        return "plays-role";
    }

    @Override
    public String getProperty() {
        return this.role.getPrintableName();
    }

    @Override
    public Collection<EquivalentFragmentSet> match(VarName start) {
        return Sets.newHashSet((Object[])new EquivalentFragmentSet[]{EquivalentFragmentSet.create(Fragments.outPlaysRole(start, this.role.getVarName(), this.required), Fragments.inPlaysRole(this.role.getVarName(), start, this.required))});
    }

    @Override
    public Stream<VarAdmin> getTypes() {
        return Stream.of(this.role);
    }

    @Override
    public Stream<VarAdmin> getInnerVars() {
        return Stream.of(this.role);
    }

    @Override
    public void insert(InsertQueryExecutor insertQueryExecutor, Concept concept) throws IllegalStateException {
        RoleType roleType = insertQueryExecutor.getConcept(this.role).asRoleType();
        concept.asType().playsRole(roleType);
    }

    @Override
    public void delete(GraknGraph graph, Concept concept) {
        String roleName = (String)this.role.getTypeName().orElseThrow(() -> PlaysRoleProperty.failDelete(this));
        concept.asType().deletePlaysRole(graph.getRoleType(roleName));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlaysRoleProperty that = (PlaysRoleProperty)o;
        return this.required == that.required && this.role.equals(that.role);
    }

    public int hashCode() {
        int result = this.role.hashCode();
        result = 31 * result + (this.required ? 1 : 0);
        return result;
    }
}

