/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Instance;
import ai.grakn.concept.Relation;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Type;
import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.RelationPlayer;
import ai.grakn.graql.admin.UniqueVarProperty;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.ShortcutTraversal;
import ai.grakn.graql.internal.gremlin.fragment.Fragments;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.pattern.property.VarPropertyInternal;
import ai.grakn.graql.internal.query.InsertQueryExecutor;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RelationProperty
extends AbstractVarProperty
implements UniqueVarProperty,
VarPropertyInternal {
    private final ImmutableMultiset<RelationPlayer> relationPlayers;

    public RelationProperty(ImmutableMultiset<RelationPlayer> relationPlayers) {
        this.relationPlayers = relationPlayers;
    }

    public Stream<RelationPlayer> getRelationPlayers() {
        return this.relationPlayers.stream();
    }

    public void buildString(StringBuilder builder) {
        builder.append("(").append(this.relationPlayers.stream().map(Object::toString).collect(Collectors.joining(", "))).append(")");
    }

    @Override
    public void modifyShortcutTraversal(ShortcutTraversal shortcutTraversal) {
        this.relationPlayers.forEach(relationPlayer -> {
            Optional roleType = relationPlayer.getRoleType();
            if (roleType.isPresent()) {
                Optional roleTypeName = ((VarAdmin)roleType.get()).getTypeName();
                if (roleTypeName.isPresent()) {
                    shortcutTraversal.addRel((String)roleTypeName.get(), relationPlayer.getRolePlayer().getVarName());
                } else {
                    shortcutTraversal.setInvalid();
                }
            } else {
                shortcutTraversal.addRel(relationPlayer.getRolePlayer().getVarName());
            }
        });
    }

    @Override
    public Collection<EquivalentFragmentSet> match(VarName start) {
        HashSet castingNames = new HashSet();
        ImmutableSet traversals = this.relationPlayers.stream().flatMap(relationPlayer -> {
            VarName castingName = Patterns.varName();
            castingNames.add(castingName);
            return this.equivalentFragmentSetFromCasting(start, castingName, (RelationPlayer)relationPlayer);
        }).collect(CommonUtil.toImmutableSet());
        ImmutableSet distinctCastingTraversals = castingNames.stream().flatMap(castingName -> castingNames.stream().filter(otherName -> !otherName.equals(castingName)).map(otherName -> this.makeDistinctCastingPattern((VarName)castingName, (VarName)otherName))).collect(CommonUtil.toImmutableSet());
        return Sets.union(traversals, distinctCastingTraversals);
    }

    @Override
    public Stream<VarAdmin> getTypes() {
        return this.relationPlayers.stream().map(RelationPlayer::getRoleType).flatMap(CommonUtil::optionalToStream);
    }

    @Override
    public Stream<VarAdmin> getInnerVars() {
        return this.relationPlayers.stream().flatMap(relationPlayer -> {
            Stream.Builder<VarAdmin> builder = Stream.builder();
            builder.add(relationPlayer.getRolePlayer());
            relationPlayer.getRoleType().ifPresent(builder::add);
            return builder.build();
        });
    }

    private Stream<EquivalentFragmentSet> equivalentFragmentSetFromCasting(VarName start, VarName castingName, RelationPlayer relationPlayer) {
        Optional roleType = relationPlayer.getRoleType();
        if (roleType.isPresent()) {
            return this.addRelatesPattern(start, castingName, (VarAdmin)roleType.get(), relationPlayer.getRolePlayer());
        }
        return this.addRelatesPattern(start, castingName, relationPlayer.getRolePlayer());
    }

    private Stream<EquivalentFragmentSet> addRelatesPattern(VarName start, VarName casting, VarAdmin rolePlayer) {
        VarName other = rolePlayer.getVarName();
        return Stream.of(EquivalentFragmentSet.create(Fragments.outCasting(start, casting), Fragments.inCasting(casting, start)), EquivalentFragmentSet.create(Fragments.outRolePlayer(casting, other), Fragments.inRolePlayer(other, casting)));
    }

    private Stream<EquivalentFragmentSet> addRelatesPattern(VarName start, VarName casting, VarAdmin roleType, VarAdmin rolePlayer) {
        VarName roletypeName = roleType.getVarName();
        VarName roleplayerName = rolePlayer.getVarName();
        return Stream.of(EquivalentFragmentSet.create(Fragments.outCasting(start, casting), Fragments.inCasting(casting, start)), EquivalentFragmentSet.create(Fragments.outRolePlayer(casting, roleplayerName), Fragments.inRolePlayer(roleplayerName, casting)), EquivalentFragmentSet.create(Fragments.outIsaCastings(casting, roletypeName), Fragments.inIsaCastings(roletypeName, casting)));
    }

    private EquivalentFragmentSet makeDistinctCastingPattern(VarName casting, VarName otherCastingId) {
        return EquivalentFragmentSet.create(Fragments.distinctCasting(casting, otherCastingId), Fragments.distinctCasting(otherCastingId, casting));
    }

    @Override
    public void checkValidProperty(GraknGraph graph, VarAdmin var) throws IllegalStateException {
        Set<String> roleTypes = this.relationPlayers.stream().map(RelationPlayer::getRoleType).flatMap(CommonUtil::optionalToStream).map(VarAdmin::getTypeName).flatMap(CommonUtil::optionalToStream).collect(Collectors.toSet());
        Optional maybeName = var.getProperty(IsaProperty.class).map(IsaProperty::getType).flatMap(VarAdmin::getTypeName);
        maybeName.ifPresent(name -> {
            RelationType relationType = graph.getRelationType(name);
            if (relationType == null) {
                throw new IllegalStateException(ErrorMessage.NOT_A_RELATION_TYPE.getMessage(new Object[]{name}));
            }
            Collection relationTypes = relationType.subTypes();
            Set validRoles = relationTypes.stream().flatMap(r -> r.hasRoles().stream()).map(Type::getName).collect(Collectors.toSet());
            String errors = roleTypes.stream().filter(roleType -> !validRoles.contains(roleType)).map(roleType -> ErrorMessage.NOT_ROLE_IN_RELATION.getMessage(new Object[]{roleType, name, validRoles})).collect(Collectors.joining("\n"));
            if (!errors.equals("")) {
                throw new IllegalStateException(errors);
            }
        });
        roleTypes.forEach(roleId -> {
            if (graph.getRoleType(roleId) == null) {
                throw new IllegalStateException(ErrorMessage.NOT_A_ROLE_TYPE.getMessage(new Object[]{roleId, roleId}));
            }
        });
    }

    @Override
    public void checkInsertable(VarAdmin var) throws IllegalStateException {
        if (!var.hasProperty(IsaProperty.class)) {
            throw new IllegalStateException(ErrorMessage.INSERT_RELATION_WITHOUT_ISA.getMessage(new Object[0]));
        }
    }

    @Override
    public void insert(InsertQueryExecutor insertQueryExecutor, Concept concept) throws IllegalStateException {
        Relation relation = concept.asRelation();
        this.relationPlayers.forEach(relationPlayer -> this.addRoleplayer(insertQueryExecutor, relation, (RelationPlayer)relationPlayer));
    }

    private void addRoleplayer(InsertQueryExecutor insertQueryExecutor, Relation relation, RelationPlayer relationPlayer) {
        VarAdmin roleVar = (VarAdmin)relationPlayer.getRoleType().orElseThrow(() -> new IllegalStateException(ErrorMessage.INSERT_RELATION_WITHOUT_ROLE_TYPE.getMessage(new Object[0])));
        RoleType roleType = insertQueryExecutor.getConcept(roleVar).asRoleType();
        Instance roleplayer = insertQueryExecutor.getConcept(relationPlayer.getRolePlayer()).asInstance();
        relation.putRolePlayer(roleType, roleplayer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationProperty that = (RelationProperty)o;
        return this.relationPlayers.equals(that.relationPlayers);
    }

    public int hashCode() {
        return this.relationPlayers.hashCode();
    }
}

