/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Type;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Printer;
import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.InsertQueryAdmin;
import ai.grakn.graql.admin.MatchQueryAdmin;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.pattern.property.VarPropertyInternal;
import ai.grakn.graql.internal.query.InsertQueryExecutor;
import ai.grakn.graql.internal.query.Queries;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableCollection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class InsertQueryImpl
implements InsertQueryAdmin {
    private final Optional<MatchQueryAdmin> matchQuery;
    private final Optional<GraknGraph> graph;
    private final ImmutableCollection<VarAdmin> originalVars;
    private final ImmutableCollection<VarAdmin> vars;

    InsertQueryImpl(ImmutableCollection<VarAdmin> vars, Optional<MatchQueryAdmin> matchQuery, Optional<GraknGraph> graph) {
        assert (!matchQuery.isPresent() || !graph.isPresent());
        this.matchQuery = matchQuery;
        this.graph = graph;
        this.originalVars = vars;
        this.vars = (ImmutableCollection)vars.stream().flatMap(v -> v.getImplicitInnerVars().stream()).collect(CommonUtil.toImmutableList());
        for (VarAdmin var : this.vars) {
            var.getProperties().forEach(property -> ((VarPropertyInternal)property).checkInsertable(var));
        }
    }

    public InsertQuery withGraph(GraknGraph graph) {
        return (InsertQuery)this.matchQuery.map(m -> Queries.insert(this.vars, m.withGraph(graph).admin())).orElseGet(() -> new InsertQueryImpl(this.vars, Optional.empty(), Optional.of(graph)));
    }

    public List<Map<String, Concept>> execute() {
        return this.stream().collect(Collectors.toList());
    }

    public Stream<String> resultsString(Printer printer) {
        return this.streamWithVarNames().map(arg_0 -> ((Printer)printer).graqlString(arg_0));
    }

    public boolean isReadOnly() {
        return false;
    }

    public Stream<Map<String, Concept>> stream() {
        return this.streamWithVarNames().map(CommonUtil::resultVarNameToString);
    }

    public Stream<Map<VarName, Concept>> streamWithVarNames() {
        GraknGraph theGraph = this.getGraph().orElseThrow(() -> new IllegalStateException(ErrorMessage.NO_GRAPH.getMessage(new Object[0])));
        InsertQueryExecutor executor = new InsertQueryExecutor((Collection<VarAdmin>)this.vars, theGraph);
        return this.matchQuery.map(query -> query.streamWithVarNames().map(executor::insertAll)).orElseGet(() -> Stream.of(executor.insertAll()));
    }

    public InsertQueryAdmin admin() {
        return this;
    }

    public Optional<? extends MatchQuery> getMatchQuery() {
        return this.matchQuery;
    }

    public Set<Type> getTypes() {
        GraknGraph theGraph = this.getGraph().orElseThrow(() -> new IllegalStateException(ErrorMessage.NO_GRAPH.getMessage(new Object[0])));
        Set<Type> types = this.vars.stream().flatMap(v -> v.getInnerVars().stream()).map(VarAdmin::getTypeName).flatMap(CommonUtil::optionalToStream).map(arg_0 -> ((GraknGraph)theGraph).getType(arg_0)).collect(Collectors.toSet());
        this.matchQuery.ifPresent(mq -> types.addAll(mq.getTypes()));
        return types;
    }

    public Collection<VarAdmin> getVars() {
        return this.originalVars;
    }

    public Optional<GraknGraph> getGraph() {
        return this.matchQuery.map(MatchQueryAdmin::getGraph).orElse(this.graph);
    }

    public String toString() {
        String mq = this.matchQuery.map(match -> match + "\n").orElse("");
        return mq + "insert " + this.originalVars.stream().map(v -> v + ";").collect(Collectors.joining("\n")).trim();
    }
}

