/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query;

import ai.grakn.GraknGraph;
import ai.grakn.graql.Aggregate;
import ai.grakn.graql.ComputeQueryBuilder;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Query;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.parser.QueryParser;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.query.InsertQueryImpl;
import ai.grakn.graql.internal.query.analytics.ComputeQueryBuilderImpl;
import ai.grakn.graql.internal.query.match.MatchQueryBase;
import ai.grakn.graql.internal.template.TemplateParser;
import ai.grakn.graql.internal.util.AdminConverter;
import ai.grakn.graql.macro.Macro;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class QueryBuilderImpl
implements QueryBuilder {
    private final Optional<GraknGraph> graph;
    private final QueryParser queryParser;
    private final TemplateParser templateParser;
    private boolean infer = false;
    private boolean materialise = false;

    public QueryBuilderImpl() {
        this.graph = Optional.empty();
        this.queryParser = QueryParser.create(this);
        this.templateParser = TemplateParser.create();
    }

    public QueryBuilderImpl(GraknGraph graph) {
        this.graph = Optional.of(graph);
        this.queryParser = QueryParser.create(this);
        this.templateParser = TemplateParser.create();
    }

    public QueryBuilder infer(boolean infer) {
        this.infer = infer;
        return this;
    }

    public QueryBuilder materialise(boolean materialise) {
        this.materialise = materialise;
        return this;
    }

    public MatchQuery match(Pattern ... patterns) {
        return this.match(Arrays.asList(patterns));
    }

    public MatchQuery match(Collection<? extends Pattern> patterns) {
        Conjunction conjunction = Patterns.conjunction(Sets.newHashSet(AdminConverter.getPatternAdmins(patterns)));
        MatchQueryBase base = new MatchQueryBase(conjunction);
        MatchQueryBase query = this.infer ? base.infer(this.materialise).admin() : base;
        return this.graph.map(arg_0 -> ((MatchQuery)query).withGraph(arg_0)).orElse((MatchQuery)query);
    }

    public InsertQuery insert(Var ... vars) {
        return this.insert(Arrays.asList(vars));
    }

    public InsertQuery insert(Collection<? extends Var> vars) {
        ImmutableList varAdmins = ImmutableList.copyOf(AdminConverter.getVarAdmins(vars));
        return new InsertQueryImpl((ImmutableCollection<VarAdmin>)varAdmins, Optional.empty(), this.graph);
    }

    public ComputeQueryBuilder compute() {
        return new ComputeQueryBuilderImpl(this.graph);
    }

    public Stream<Pattern> parsePatterns(InputStream inputStream) {
        return this.queryParser.parsePatterns(inputStream);
    }

    public List<Pattern> parsePatterns(String patternsString) {
        return this.queryParser.parsePatterns(patternsString);
    }

    public Pattern parsePattern(String patternString) {
        return this.queryParser.parsePattern(patternString);
    }

    public <T extends Query<?>> T parse(String queryString) {
        return this.queryParser.parseQuery(queryString);
    }

    public List<Query<?>> parseList(String queryString) {
        return this.queryParser.parseList(queryString);
    }

    public <T extends Query<?>> T parseTemplate(String template, Map<String, Object> data) {
        return this.parse(this.templateParser.parseTemplate(template, data));
    }

    public void registerAggregate(String name, Function<List<Object>, Aggregate> aggregateMethod) {
        this.queryParser.registerAggregate(name, aggregateMethod);
    }

    public void registerMacro(Macro macro) {
        this.templateParser.registerMacro(macro.name(), macro);
    }
}

