/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.aggregate;

import ai.grakn.concept.Concept;
import ai.grakn.graql.Aggregate;
import ai.grakn.graql.NamedAggregate;
import ai.grakn.graql.VarName;
import ai.grakn.graql.internal.query.aggregate.AverageAggregate;
import ai.grakn.graql.internal.query.aggregate.CountAggregate;
import ai.grakn.graql.internal.query.aggregate.GroupAggregate;
import ai.grakn.graql.internal.query.aggregate.ListAggregate;
import ai.grakn.graql.internal.query.aggregate.MaxAggregate;
import ai.grakn.graql.internal.query.aggregate.MedianAggregate;
import ai.grakn.graql.internal.query.aggregate.MinAggregate;
import ai.grakn.graql.internal.query.aggregate.SelectAggregate;
import ai.grakn.graql.internal.query.aggregate.SumAggregate;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Aggregates {
    private Aggregates() {
    }

    public static Aggregate<Map<VarName, Concept>, Optional<Double>> average(VarName varName) {
        return new AverageAggregate(varName);
    }

    public static Aggregate<Object, Long> count() {
        return new CountAggregate();
    }

    public static Aggregate<Map<VarName, Concept>, Map<Concept, List<Map<VarName, Concept>>>> group(VarName varName) {
        return Aggregates.group(varName, Aggregates.list());
    }

    public static <T> Aggregate<Map<VarName, Concept>, Map<Concept, T>> group(VarName varName, Aggregate<? super Map<VarName, Concept>, T> innerAggregate) {
        return new GroupAggregate<T>(varName, innerAggregate);
    }

    public static <T> Aggregate<T, List<T>> list() {
        return new ListAggregate();
    }

    public static <T extends Comparable<T>> Aggregate<Map<VarName, Concept>, Optional<T>> max(VarName varName) {
        return new MaxAggregate(varName);
    }

    public static Aggregate<Map<VarName, Concept>, Optional<Number>> median(VarName varName) {
        return new MedianAggregate(varName);
    }

    public static <T extends Comparable<T>> Aggregate<Map<VarName, Concept>, Optional<T>> min(VarName varName) {
        return new MinAggregate(varName);
    }

    public static <S, T> Aggregate<S, Map<String, T>> select(ImmutableSet<NamedAggregate<? super S, ? extends T>> aggregates) {
        return new SelectAggregate<S, T>(aggregates);
    }

    public static Aggregate<Map<VarName, Concept>, Number> sum(VarName varName) {
        return new SumAggregate(varName);
    }
}

