/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.aggregate;

import ai.grakn.concept.Concept;
import ai.grakn.graql.Aggregate;
import ai.grakn.graql.VarName;
import ai.grakn.graql.internal.query.aggregate.AbstractAggregate;
import ai.grakn.graql.internal.query.aggregate.ListAggregate;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class GroupAggregate<T>
extends AbstractAggregate<Map<VarName, Concept>, Map<Concept, T>> {
    private final VarName varName;
    private final Aggregate<? super Map<VarName, Concept>, T> innerAggregate;

    GroupAggregate(VarName varName, Aggregate<? super Map<VarName, Concept>, T> innerAggregate) {
        this.varName = varName;
        this.innerAggregate = innerAggregate;
    }

    public Map<Concept, T> apply(Stream<? extends Map<VarName, Concept>> stream) {
        Collector applyAggregate = Collectors.collectingAndThen(Collectors.toList(), list -> this.innerAggregate.apply(list.stream()));
        return stream.collect(Collectors.groupingBy(result -> (Concept)result.get(this.varName), applyAggregate));
    }

    public String toString() {
        if (this.innerAggregate instanceof ListAggregate) {
            return "group " + this.varName;
        }
        return "group " + this.varName + " " + this.innerAggregate.toString();
    }
}

