/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.aggregate;

import ai.grakn.concept.Concept;
import ai.grakn.graql.VarName;
import ai.grakn.graql.internal.query.aggregate.AbstractAggregate;
import java.util.Map;
import java.util.stream.Stream;

class SumAggregate
extends AbstractAggregate<Map<VarName, Concept>, Number> {
    private final VarName varName;

    SumAggregate(VarName varName) {
        this.varName = varName;
    }

    public Number apply(Stream<? extends Map<VarName, Concept>> stream) {
        return stream.map(result -> (Number)((Concept)result.get(this.varName)).asResource().getValue()).reduce(0, this::add);
    }

    private Number add(Number x, Number y) {
        if (x instanceof Long || y instanceof Long) {
            return x.longValue() + y.longValue();
        }
        return x.doubleValue() + y.doubleValue();
    }

    public String toString() {
        return "sum " + this.varName;
    }
}

