/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.Grakn;
import ai.grakn.GraknComputer;
import ai.grakn.GraknGraph;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Instance;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraknValidationException;
import ai.grakn.graql.ComputeQuery;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Printer;
import ai.grakn.graql.internal.analytics.CommonOLAP;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractComputeQuery<T>
implements ComputeQuery<T> {
    private static final int numberOfOntologyChecks = 10;
    static final Logger LOGGER = LoggerFactory.getLogger(ComputeQuery.class);
    Optional<GraknGraph> graph = Optional.empty();
    String keySpace;
    Set<String> subTypeNames = new HashSet<String>();

    AbstractComputeQuery() {
    }

    public ComputeQuery<T> withGraph(GraknGraph graph) {
        this.graph = Optional.of(graph);
        return this;
    }

    public ComputeQuery<T> in(String ... subTypeNames) {
        this.subTypeNames = Sets.newHashSet((Object[])subTypeNames);
        return this;
    }

    public ComputeQuery<T> in(Collection<String> subTypeNames) {
        this.subTypeNames = Sets.newHashSet(subTypeNames);
        return this;
    }

    public Stream<String> resultsString(Printer printer) {
        Object computeResult = this.execute();
        if (computeResult instanceof Map) {
            if (((Map)computeResult).isEmpty()) {
                return Stream.of("There are no instances of the selected type(s).");
            }
            if (((Map)computeResult).values().iterator().next() instanceof Set) {
                Map map = (Map)computeResult;
                return map.entrySet().stream().map(entry -> {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Object s : (Iterable)entry.getValue()) {
                        stringBuilder.append(entry.getKey()).append("\t").append(s).append("\n");
                    }
                    return stringBuilder.toString();
                });
            }
        }
        return Stream.of(printer.graqlString(computeResult));
    }

    void initSubGraph() {
        GraknGraph theGraph = this.graph.orElseThrow(() -> new IllegalStateException(ErrorMessage.NO_GRAPH.getMessage(new Object[0])));
        this.keySpace = theGraph.getKeyspace();
        try {
            theGraph.rollback();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.getAllSubTypes(theGraph);
    }

    private void getAllSubTypes(GraknGraph graph) {
        Set subGraph = this.subTypeNames.stream().map(name -> {
            Type type = graph.getType(name);
            if (type == null) {
                throw new IllegalArgumentException(ErrorMessage.NAME_NOT_FOUND.getMessage(new Object[]{name}));
            }
            return type;
        }).collect(Collectors.toSet());
        if (subGraph.isEmpty()) {
            EntityType metaEntityType = graph.admin().getMetaEntityType();
            metaEntityType.subTypes().forEach(type -> this.subTypeNames.add(type.asType().getName()));
            ResourceType metaResourceType = graph.admin().getMetaResourceType();
            metaResourceType.subTypes().forEach(type -> this.subTypeNames.add(type.asType().getName()));
            RelationType metaRelationType = graph.admin().getMetaRelationType();
            metaRelationType.subTypes().forEach(type -> this.subTypeNames.add(type.asType().getName()));
            this.subTypeNames.remove(metaEntityType.getName());
            this.subTypeNames.remove(metaResourceType.getName());
            this.subTypeNames.remove(metaRelationType.getName());
            this.subTypeNames.removeAll(CommonOLAP.analyticsElements);
        } else {
            for (Type type2 : subGraph) {
                type2.subTypes().forEach(subType -> this.subTypeNames.add(subType.getName()));
            }
        }
    }

    GraknComputer getGraphComputer() {
        return Grakn.factory((String)"localhost:4567", (String)this.keySpace).getGraphComputer();
    }

    boolean selectedTypesHaveInstance() {
        if (this.subTypeNames.isEmpty()) {
            return false;
        }
        List checkSubtypes = this.subTypeNames.stream().map(type -> Graql.var("x").isa(type)).collect(Collectors.toList());
        return (Boolean)this.graph.get().graql().infer(false).match(new Pattern[]{Graql.or(checkSubtypes)}).ask().execute();
    }

    boolean verticesExistInSubgraph(ConceptId ... ids) {
        for (ConceptId id : ids) {
            Instance instance = (Instance)this.graph.get().getConcept(id);
            if (instance != null && this.subTypeNames.contains(instance.type().getName())) continue;
            return false;
        }
        return true;
    }

    void mutateResourceOntology(String resourceTypeName, ResourceType.DataType<?> resourceDataType) {
        GraknGraph theGraph = this.graph.get();
        ResourceType resource = theGraph.putResourceType(resourceTypeName, resourceDataType);
        for (String type : this.subTypeNames) {
            theGraph.getType(type).hasResource(resource);
        }
        try {
            theGraph.commit();
        }
        catch (GraknValidationException e) {
            throw new RuntimeException(ErrorMessage.ONTOLOGY_MUTATION.getMessage(new Object[]{e.getMessage()}), e);
        }
    }

    void waitOnMutateResourceOntology(String resourceTypeId) {
        GraknGraph theGraph = this.graph.get();
        theGraph.showImplicitConcepts(true);
        for (int i = 0; i < 10; ++i) {
            RelationType relationType;
            RoleType degreeValue;
            RoleType degreeOwner;
            boolean isOntologyComplete = true;
            try {
                theGraph.rollback();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            ResourceType resource = theGraph.getResourceType(resourceTypeId);
            if (resource == null || (degreeOwner = theGraph.getRoleType(Schema.Resource.HAS_RESOURCE_OWNER.getName(resourceTypeId))) == null || (degreeValue = theGraph.getRoleType(Schema.Resource.HAS_RESOURCE_VALUE.getName(resourceTypeId))) == null || (relationType = theGraph.getRelationType(Schema.Resource.HAS_RESOURCE.getName(resourceTypeId))) == null) continue;
            for (String type : this.subTypeNames) {
                Collection roles = theGraph.getType(type).playsRoles();
                if (roles.contains(degreeOwner)) continue;
                isOntologyComplete = false;
                break;
            }
            if (!isOntologyComplete) continue;
            theGraph.showImplicitConcepts(false);
            return;
        }
        theGraph.showImplicitConcepts(false);
        throw new RuntimeException(ErrorMessage.ONTOLOGY_MUTATION.getMessage(new Object[]{"Failed to confirm ontology is present after mutation."}));
    }

    abstract String graqlString();

    final String subtypeString() {
        if (this.subTypeNames.isEmpty()) {
            return ";";
        }
        return " in " + this.subTypeNames.stream().map(StringConverter::idToString).collect(Collectors.joining(", ")) + ";";
    }

    public String toString() {
        return "compute " + this.graqlString();
    }

    Set<String> getHasResourceRelationTypes() {
        return this.subTypeNames.stream().filter(type -> this.graph.get().getType(type).isResourceType()).map(arg_0 -> ((Schema.Resource)Schema.Resource.HAS_RESOURCE).getName(arg_0)).collect(Collectors.toSet());
    }
}

