/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknComputer;
import ai.grakn.GraknGraph;
import ai.grakn.concept.ResourceType;
import ai.grakn.graql.analytics.ClusterQuery;
import ai.grakn.graql.internal.analytics.ClusterMemberMapReduce;
import ai.grakn.graql.internal.analytics.ClusterSizeMapReduce;
import ai.grakn.graql.internal.analytics.CommonOLAP;
import ai.grakn.graql.internal.analytics.ConnectedComponentVertexProgram;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class ClusterQueryImpl<T>
extends AbstractComputeQuery<T>
implements ClusterQuery<T> {
    private boolean members = false;
    private boolean persist = false;
    private boolean anySize = true;
    private long clusterSize = -1L;
    private String clusterName = Schema.Analytics.CLUSTER.getName();

    ClusterQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public T execute() {
        ComputerResult result;
        LOGGER.info("ConnectedComponentsVertexProgram is called");
        this.initSubGraph();
        if (!this.selectedTypesHaveInstance()) {
            return (T)Collections.emptyMap();
        }
        GraknComputer computer = this.getGraphComputer();
        Set<String> withResourceRelationTypes = this.getHasResourceRelationTypes();
        withResourceRelationTypes.addAll(this.subTypeNames);
        if (this.members) {
            if (this.persist) {
                if (!Sets.intersection((Set)this.subTypeNames, CommonOLAP.analyticsElements).isEmpty()) {
                    throw new IllegalStateException(ErrorMessage.ILLEGAL_ARGUMENT_EXCEPTION.getMessage(new Object[]{this.getClass().toString()}));
                }
                this.mutateResourceOntology(this.clusterName, ResourceType.DataType.STRING);
                this.waitOnMutateResourceOntology(this.clusterName);
                if (this.anySize) {
                    result = computer.compute((VertexProgram)new ConnectedComponentVertexProgram(withResourceRelationTypes, this.subTypeNames, this.keySpace, this.clusterName), new MapReduce[]{new ClusterMemberMapReduce(this.subTypeNames, "connectedComponentVertexProgram.clusterLabel")});
                } else {
                    result = computer.compute((VertexProgram)new ConnectedComponentVertexProgram(withResourceRelationTypes), new MapReduce[]{new ClusterSizeMapReduce(this.subTypeNames, "connectedComponentVertexProgram.clusterLabel", this.clusterSize)});
                    result = computer.compute((VertexProgram)new ConnectedComponentVertexProgram(withResourceRelationTypes, this.subTypeNames, this.keySpace, this.clusterName, ((Map)result.memory().get("GraknMapReduce.memoryKey")).keySet()), new MapReduce[]{new ClusterMemberMapReduce(this.subTypeNames, "connectedComponentVertexProgram.clusterLabel", this.clusterSize)});
                }
            } else {
                result = this.anySize ? computer.compute((VertexProgram)new ConnectedComponentVertexProgram(withResourceRelationTypes), new MapReduce[]{new ClusterMemberMapReduce(this.subTypeNames, "connectedComponentVertexProgram.clusterLabel")}) : computer.compute((VertexProgram)new ConnectedComponentVertexProgram(withResourceRelationTypes), new MapReduce[]{new ClusterMemberMapReduce(this.subTypeNames, "connectedComponentVertexProgram.clusterLabel", this.clusterSize)});
            }
        } else if (this.persist) {
            if (!Sets.intersection((Set)this.subTypeNames, CommonOLAP.analyticsElements).isEmpty()) {
                throw new IllegalStateException(ErrorMessage.ILLEGAL_ARGUMENT_EXCEPTION.getMessage(new Object[]{this.getClass().toString()}));
            }
            this.mutateResourceOntology(this.clusterName, ResourceType.DataType.STRING);
            this.waitOnMutateResourceOntology(this.clusterName);
            if (this.anySize) {
                result = computer.compute((VertexProgram)new ConnectedComponentVertexProgram(withResourceRelationTypes, this.subTypeNames, this.keySpace, this.clusterName), new MapReduce[]{new ClusterSizeMapReduce(this.subTypeNames, "connectedComponentVertexProgram.clusterLabel")});
            } else {
                result = computer.compute((VertexProgram)new ConnectedComponentVertexProgram(withResourceRelationTypes), new MapReduce[]{new ClusterSizeMapReduce(this.subTypeNames, "connectedComponentVertexProgram.clusterLabel", this.clusterSize)});
                result = computer.compute((VertexProgram)new ConnectedComponentVertexProgram(withResourceRelationTypes, this.subTypeNames, this.keySpace, this.clusterName, ((Map)result.memory().get("GraknMapReduce.memoryKey")).keySet()), new MapReduce[]{new ClusterSizeMapReduce(this.subTypeNames, "connectedComponentVertexProgram.clusterLabel", this.clusterSize)});
            }
        } else {
            result = this.anySize ? computer.compute((VertexProgram)new ConnectedComponentVertexProgram(withResourceRelationTypes), new MapReduce[]{new ClusterSizeMapReduce(this.subTypeNames, "connectedComponentVertexProgram.clusterLabel")}) : computer.compute((VertexProgram)new ConnectedComponentVertexProgram(withResourceRelationTypes), new MapReduce[]{new ClusterSizeMapReduce(this.subTypeNames, "connectedComponentVertexProgram.clusterLabel", this.clusterSize)});
        }
        LOGGER.info("ConnectedComponentsVertexProgram is done");
        return (T)result.memory().get("GraknMapReduce.memoryKey");
    }

    public boolean isReadOnly() {
        return this.persist;
    }

    public ClusterQuery<Map<String, Set<String>>> members() {
        this.members = true;
        return this;
    }

    public ClusterQuery<T> persist() {
        this.persist = true;
        return this;
    }

    public ClusterQuery<T> persist(String resourceTypeName) {
        this.clusterName = resourceTypeName;
        return this.persist();
    }

    public ClusterQuery<T> clusterSize(long clusterSize) {
        this.anySize = false;
        this.clusterSize = clusterSize;
        return this;
    }

    @Override
    public ClusterQuery<T> in(String ... subTypeNames) {
        return (ClusterQuery)super.in(subTypeNames);
    }

    @Override
    public ClusterQuery<T> in(Collection<String> subTypeNames) {
        return (ClusterQuery)super.in(subTypeNames);
    }

    @Override
    String graqlString() {
        String string = "cluster" + this.subtypeString();
        if (this.members) {
            string = string + " members;";
        }
        if (!this.anySize) {
            string = string + " size " + this.clusterSize + ";";
        }
        if (this.persist) {
            string = string + " persist";
            if (!this.clusterName.equals(Schema.Analytics.CLUSTER.getName())) {
                string = string + " " + StringConverter.idToString(this.clusterName);
            }
            string = string + ";";
        }
        return string;
    }

    @Override
    public ClusterQuery<T> withGraph(GraknGraph graph) {
        return (ClusterQuery)super.withGraph(graph);
    }
}

