/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknGraph;
import ai.grakn.graql.analytics.CountQuery;
import ai.grakn.graql.internal.analytics.CountMapReduce;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;

class CountQueryImpl
extends AbstractComputeQuery<Long>
implements CountQuery {
    CountQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public Long execute() {
        LOGGER.info("CountMapReduce is called");
        this.initSubGraph();
        if (!this.selectedTypesHaveInstance()) {
            return 0L;
        }
        ComputerResult result = this.getGraphComputer().compute((MapReduce)new CountMapReduce(this.subTypeNames));
        Map count = (Map)result.memory().get("GraknMapReduce.memoryKey");
        LOGGER.info("CountMapReduce is done");
        return count.getOrDefault("count", 0L);
    }

    public boolean isReadOnly() {
        return true;
    }

    public CountQuery in(String ... subTypeNames) {
        return (CountQuery)super.in(subTypeNames);
    }

    public CountQuery in(Collection<String> subTypeNames) {
        return (CountQuery)super.in(subTypeNames);
    }

    @Override
    String graqlString() {
        return "count" + this.subtypeString();
    }

    public CountQuery withGraph(GraknGraph graph) {
        return (CountQuery)super.withGraph(graph);
    }
}

