/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknComputer;
import ai.grakn.GraknGraph;
import ai.grakn.concept.ResourceType;
import ai.grakn.graql.analytics.DegreeQuery;
import ai.grakn.graql.internal.analytics.CommonOLAP;
import ai.grakn.graql.internal.analytics.DegreeAndPersistVertexProgram;
import ai.grakn.graql.internal.analytics.DegreeDistributionMapReduce;
import ai.grakn.graql.internal.analytics.DegreeVertexProgram;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class DegreeQueryImpl<T>
extends AbstractComputeQuery<T>
implements DegreeQuery<T> {
    private boolean persist = false;
    private boolean ofTypeNamesSet = false;
    private Set<String> ofTypeNames = new HashSet<String>();
    private String degreeName = Schema.Analytics.DEGREE.getName();

    DegreeQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public T execute() {
        if (this.persist) {
            LOGGER.info("DegreeAndPersistVertexProgram is called");
        } else {
            LOGGER.info("DegreeVertexProgram is called");
        }
        this.initSubGraph();
        if (!this.selectedTypesHaveInstance()) {
            return (T)Collections.emptyMap();
        }
        this.ofTypeNames.forEach(type -> {
            if (!this.subTypeNames.contains(type)) {
                throw new IllegalStateException(ErrorMessage.ILLEGAL_ARGUMENT_EXCEPTION.getMessage(new Object[]{type}));
            }
        });
        GraknComputer computer = this.getGraphComputer();
        Set<String> withResourceRelationTypes = this.getHasResourceRelationTypes();
        withResourceRelationTypes.addAll(this.subTypeNames);
        if (this.ofTypeNames.isEmpty()) {
            this.ofTypeNames.addAll(this.subTypeNames);
        }
        if (this.persist) {
            if (!Sets.intersection((Set)this.subTypeNames, CommonOLAP.analyticsElements).isEmpty()) {
                throw new IllegalStateException(ErrorMessage.ILLEGAL_ARGUMENT_EXCEPTION.getMessage(new Object[]{this.getClass().toString()}));
            }
            this.mutateResourceOntology(this.degreeName, ResourceType.DataType.LONG);
            this.waitOnMutateResourceOntology(this.degreeName);
            computer.compute((VertexProgram)new DegreeAndPersistVertexProgram(withResourceRelationTypes, this.ofTypeNames, this.keySpace, this.degreeName), new MapReduce[0]);
            LOGGER.info("DegreeAndPersistVertexProgram is done");
            return (T)"Degrees have been persisted";
        }
        ComputerResult result = computer.compute((VertexProgram)new DegreeVertexProgram(withResourceRelationTypes, this.ofTypeNames), new MapReduce[]{new DegreeDistributionMapReduce(this.ofTypeNames)});
        LOGGER.info("DegreeVertexProgram is done");
        return (T)result.memory().get("GraknMapReduce.memoryKey");
    }

    public boolean isReadOnly() {
        return !this.persist;
    }

    public DegreeQuery<String> persist() {
        this.persist = true;
        return this;
    }

    public DegreeQuery<String> persist(String resourceTypeName) {
        this.degreeName = resourceTypeName;
        return this.persist();
    }

    @Override
    public DegreeQuery<T> in(String ... subTypeNames) {
        return (DegreeQuery)super.in(subTypeNames);
    }

    @Override
    public DegreeQuery<T> in(Collection<String> subTypeNames) {
        return (DegreeQuery)super.in(subTypeNames);
    }

    public DegreeQuery<T> of(String ... ofTypeNames) {
        if (ofTypeNames.length > 0) {
            this.ofTypeNamesSet = true;
            this.ofTypeNames = Sets.newHashSet((Object[])ofTypeNames);
        }
        return this;
    }

    public DegreeQuery<T> of(Collection<String> ofTypeNames) {
        if (!ofTypeNames.isEmpty()) {
            this.ofTypeNamesSet = true;
            this.ofTypeNames = Sets.newHashSet(ofTypeNames);
        }
        return this;
    }

    @Override
    String graqlString() {
        String string = "degrees";
        if (this.ofTypeNamesSet) {
            string = string + " of " + this.ofTypeNames.stream().map(StringConverter::idToString).collect(Collectors.joining(", "));
        }
        string = string + this.subtypeString();
        if (this.persist) {
            string = string + " persist";
            if (!this.degreeName.equals(Schema.Analytics.DEGREE.getName())) {
                string = string + " " + StringConverter.idToString(this.degreeName);
            }
            string = string + ";";
        }
        return string;
    }

    @Override
    public DegreeQuery<T> withGraph(GraknGraph graph) {
        return (DegreeQuery)super.withGraph(graph);
    }
}

