/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknGraph;
import ai.grakn.graql.analytics.MaxQuery;
import ai.grakn.graql.internal.analytics.DegreeVertexProgram;
import ai.grakn.graql.internal.analytics.MaxMapReduce;
import ai.grakn.graql.internal.query.analytics.AbstractStatisticsQuery;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class MaxQueryImpl
extends AbstractStatisticsQuery<Optional<Number>>
implements MaxQuery {
    MaxQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public Optional<Number> execute() {
        LOGGER.info("MaxMapReduce is called");
        this.initSubGraph();
        String dataType = this.checkSelectedResourceTypesHaveCorrectDataType(this.statisticsResourceTypeNames);
        if (!this.selectedResourceTypesHaveInstance(this.statisticsResourceTypeNames)) {
            return Optional.empty();
        }
        Set<String> allSubTypes = this.getCombinedSubTypes();
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new DegreeVertexProgram(allSubTypes, this.statisticsResourceTypeNames), new MapReduce[]{new MaxMapReduce(this.statisticsResourceTypeNames, dataType)});
        Map max = (Map)result.memory().get("GraknMapReduce.memoryKey");
        LOGGER.info("MaxMapReduce is done");
        return Optional.of(max.get("max"));
    }

    public MaxQuery of(String ... resourceTypeNames) {
        return (MaxQuery)this.setStatisticsResourceType(resourceTypeNames);
    }

    public MaxQuery of(Collection<String> resourceTypeNames) {
        return (MaxQuery)this.setStatisticsResourceType(resourceTypeNames);
    }

    public MaxQuery in(String ... subTypeNames) {
        return (MaxQuery)super.in(subTypeNames);
    }

    public MaxQuery in(Collection<String> subTypeNames) {
        return (MaxQuery)super.in(subTypeNames);
    }

    public MaxQuery withGraph(GraknGraph graph) {
        return (MaxQuery)super.withGraph(graph);
    }

    @Override
    String getName() {
        return "max";
    }
}

