/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknGraph;
import ai.grakn.graql.analytics.MinQuery;
import ai.grakn.graql.internal.analytics.DegreeVertexProgram;
import ai.grakn.graql.internal.analytics.MinMapReduce;
import ai.grakn.graql.internal.query.analytics.AbstractStatisticsQuery;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class MinQueryImpl
extends AbstractStatisticsQuery<Optional<Number>>
implements MinQuery {
    MinQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public Optional<Number> execute() {
        LOGGER.info("MinMapReduce is called");
        this.initSubGraph();
        String dataType = this.checkSelectedResourceTypesHaveCorrectDataType(this.statisticsResourceTypeNames);
        if (!this.selectedResourceTypesHaveInstance(this.statisticsResourceTypeNames)) {
            return Optional.empty();
        }
        Set<String> allSubTypes = this.getCombinedSubTypes();
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new DegreeVertexProgram(allSubTypes, this.statisticsResourceTypeNames), new MapReduce[]{new MinMapReduce(this.statisticsResourceTypeNames, dataType)});
        Map min = (Map)result.memory().get("GraknMapReduce.memoryKey");
        LOGGER.info("MinMapReduce is done");
        return Optional.of(min.get("min"));
    }

    public MinQuery of(String ... resourceTypeNames) {
        return (MinQuery)this.setStatisticsResourceType(resourceTypeNames);
    }

    public MinQuery of(Collection<String> resourceTypeNames) {
        return (MinQuery)this.setStatisticsResourceType(resourceTypeNames);
    }

    public MinQuery in(String ... subTypeNames) {
        return (MinQuery)super.in(subTypeNames);
    }

    public MinQuery in(Collection<String> subTypeNames) {
        return (MinQuery)super.in(subTypeNames);
    }

    public MinQuery withGraph(GraknGraph graph) {
        return (MinQuery)super.withGraph(graph);
    }

    @Override
    String getName() {
        return "min";
    }
}

