/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.graql.analytics.PathQuery;
import ai.grakn.graql.internal.analytics.ClusterMemberMapReduce;
import ai.grakn.graql.internal.analytics.ShortestPathVertexProgram;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.ErrorMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class PathQueryImpl
extends AbstractComputeQuery<Optional<List<Concept>>>
implements PathQuery {
    private ConceptId sourceId = null;
    private ConceptId destinationId = null;

    PathQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public Optional<List<Concept>> execute() {
        ComputerResult result;
        LOGGER.info("ShortestPathVertexProgram is called");
        if (this.sourceId == null) {
            throw new IllegalStateException(ErrorMessage.NO_SOURCE.getMessage(new Object[0]));
        }
        if (this.destinationId == null) {
            throw new IllegalStateException(ErrorMessage.NO_DESTINATION.getMessage(new Object[0]));
        }
        this.initSubGraph();
        if (!this.verticesExistInSubgraph(this.sourceId, this.destinationId)) {
            throw new IllegalStateException(ErrorMessage.INSTANCE_DOES_NOT_EXIST.getMessage(new Object[0]));
        }
        if (this.sourceId.equals((Object)this.destinationId)) {
            return Optional.of(Collections.singletonList(((GraknGraph)this.graph.get()).getConcept(this.sourceId)));
        }
        try {
            result = this.getGraphComputer().compute((VertexProgram)new ShortestPathVertexProgram(this.subTypeNames, this.sourceId.getValue(), this.destinationId.getValue()), new MapReduce[]{new ClusterMemberMapReduce(this.subTypeNames, "shortestPathVertexProgram.foundInIteration")});
        }
        catch (IllegalStateException e) {
            if (e.getMessage().equals(ErrorMessage.NO_PATH_EXIST.getMessage(new Object[0]))) {
                return Optional.empty();
            }
            throw e;
        }
        Map map = (Map)result.memory().get("GraknMapReduce.memoryKey");
        String middlePoint = (String)result.memory().get("shortestPathVertexProgram.middle");
        if (!middlePoint.equals("")) {
            map.put(0, Collections.singleton(middlePoint));
        }
        ArrayList<ConceptId> path = new ArrayList<ConceptId>();
        path.add(this.sourceId);
        path.addAll(map.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).map(pair -> ConceptId.of((String)((String)((Set)pair.getValue()).iterator().next()))).collect(Collectors.toList()));
        path.add(this.destinationId);
        LOGGER.debug("The path found is: " + path);
        LOGGER.info("ShortestPathVertexProgram is done");
        return Optional.of(path.stream().map(arg_0 -> ((GraknGraph)((GraknGraph)this.graph.get())).getConcept(arg_0)).collect(Collectors.toList()));
    }

    public PathQuery from(ConceptId sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    public PathQuery to(ConceptId destinationId) {
        this.destinationId = destinationId;
        return this;
    }

    public boolean isReadOnly() {
        return true;
    }

    public PathQuery in(String ... subTypeNames) {
        return (PathQuery)super.in(subTypeNames);
    }

    public PathQuery in(Collection<String> subTypeNames) {
        return (PathQuery)super.in(subTypeNames);
    }

    @Override
    String graqlString() {
        return "path from " + StringConverter.idToString(this.sourceId.getValue()) + " to " + StringConverter.idToString(this.destinationId.getValue()) + this.subtypeString();
    }

    public PathQuery withGraph(GraknGraph graph) {
        return (PathQuery)super.withGraph(graph);
    }
}

