/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.match;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Type;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.gremlin.GraqlTraversal;
import ai.grakn.graql.internal.pattern.property.VarPropertyInternal;
import ai.grakn.graql.internal.query.match.AbstractMatchQuery;
import ai.grakn.graql.internal.query.match.MatchQueryInfer;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchQueryBase
extends AbstractMatchQuery {
    protected final Logger LOG = LoggerFactory.getLogger(MatchQueryBase.class);
    private final Conjunction<PatternAdmin> pattern;
    private final ImmutableSet<String> typeNames;

    public MatchQueryBase(Conjunction<PatternAdmin> pattern) {
        if (pattern.getPatterns().size() == 0) {
            throw new IllegalArgumentException(ErrorMessage.MATCH_NO_PATTERNS.getMessage(new Object[0]));
        }
        this.pattern = pattern;
        this.typeNames = this.getAllTypeNames();
    }

    @Override
    public Stream<Map<VarName, Concept>> stream(Optional<GraknGraph> optionalGraph) {
        GraknGraph graph = optionalGraph.orElseThrow(() -> new IllegalStateException(ErrorMessage.NO_GRAPH.getMessage(new Object[0])));
        for (VarAdmin var : this.pattern.getVars()) {
            var.getProperties().forEach(property -> ((VarPropertyInternal)property).checkValid(graph, var));
        }
        GraqlTraversal graqlTraversal = GraqlTraversal.semiOptimal(this.pattern);
        this.LOG.debug("Created query plan");
        this.LOG.debug(graqlTraversal.toString());
        GraphTraversal<Vertex, Map<String, Vertex>> traversal = graqlTraversal.getGraphTraversal(graph);
        String[] selectedNames = (String[])this.getSelectedNames().stream().map(VarName::getValue).toArray(String[]::new);
        if (selectedNames.length != 0) {
            traversal.select(selectedNames[0], selectedNames[0], selectedNames);
        }
        return (Stream)traversal.toStream().map(vertices -> this.makeResults(graph, (Map<String, Vertex>)vertices)).filter(result -> this.shouldShowResult(graph, (Map<VarName, Concept>)result)).sequential();
    }

    public Set<Type> getTypes(GraknGraph graph) {
        return this.pattern.getVars().stream().flatMap(v -> v.getInnerVars().stream()).flatMap(v -> v.getTypeNames().stream()).map(arg_0 -> ((GraknGraph)graph).getType(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Set<Type> getTypes() {
        throw new IllegalStateException(ErrorMessage.NO_GRAPH.getMessage(new Object[0]));
    }

    public ImmutableSet<VarName> getSelectedNames() {
        Set conjunctions = this.pattern.getDisjunctiveNormalForm().getPatterns();
        Stream<Set> vars = conjunctions.stream().map(this::getDefinedNamesFromConjunction);
        Set names = vars.reduce(Sets::intersection).orElseThrow(() -> new RuntimeException(ErrorMessage.MATCH_NO_PATTERNS.getMessage(new Object[0])));
        return ImmutableSet.copyOf((Collection)names);
    }

    public Conjunction<PatternAdmin> getPattern() {
        return this.pattern;
    }

    public Optional<GraknGraph> getGraph() {
        return Optional.empty();
    }

    public String toString() {
        return "match " + this.pattern.getPatterns().stream().map(p -> p + ";").collect(Collectors.joining(" "));
    }

    public final MatchQuery infer(boolean materialise) {
        return new MatchQueryInfer(this, materialise);
    }

    private Set<VarName> getDefinedNamesFromConjunction(Conjunction<VarAdmin> conjunction) {
        return conjunction.getVars().stream().flatMap(var -> var.getInnerVars().stream()).filter(VarAdmin::isUserDefinedName).map(VarAdmin::getVarName).collect(Collectors.toSet());
    }

    private ImmutableSet<String> getAllTypeNames() {
        return this.pattern.getVars().stream().flatMap(var -> var.getInnerVars().stream()).map(VarAdmin::getTypeName).flatMap(CommonUtil::optionalToStream).collect(CommonUtil.toImmutableSet());
    }

    private Map<VarName, Concept> makeResults(GraknGraph graph, Map<String, Vertex> vertices) {
        return this.getSelectedNames().stream().collect(Collectors.toMap(Function.identity(), name -> graph.admin().buildConcept((Vertex)vertices.get(name.getValue()))));
    }

    private boolean shouldShowResult(GraknGraph graph, Map<VarName, Concept> result) {
        return result.values().stream().allMatch(concept -> this.shouldShowConcept(graph, (Concept)concept));
    }

    private boolean shouldShowConcept(GraknGraph graph, Concept concept) {
        if (graph.implicitConceptsVisible() || !concept.isType()) {
            return true;
        }
        Type type = concept.asType();
        return type.isImplicit() == false || this.typeNames.contains((Object)type.getName());
    }
}

