/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.match;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.graql.VarName;
import ai.grakn.graql.internal.query.match.AbstractMatchQuery;
import ai.grakn.graql.internal.query.match.MatchQueryModifier;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MatchQuerySelect
extends MatchQueryModifier {
    private final ImmutableSet<VarName> names;

    MatchQuerySelect(AbstractMatchQuery inner, ImmutableSet<VarName> names) {
        super(inner);
        if (names.isEmpty()) {
            throw new IllegalArgumentException(ErrorMessage.SELECT_NONE_SELECTED.getMessage(new Object[0]));
        }
        this.names = names;
    }

    @Override
    public Stream<Map<VarName, Concept>> stream(Optional<GraknGraph> graph) {
        return this.inner.stream(graph).map(result -> Maps.filterKeys((Map)result, arg_0 -> this.names.contains(arg_0)));
    }

    @Override
    protected String modifierString() {
        return " select " + this.names.stream().map(Object::toString).collect(Collectors.joining(", ")) + ";";
    }

    @Override
    public Set<VarName> getSelectedNames() {
        return this.names;
    }
}

