/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.predicate;

import ai.grakn.concept.ResourceType;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.ValuePredicateAdmin;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.Schema;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Vertex;

abstract class ComparatorPredicate
implements ValuePredicateAdmin {
    private final Optional<Object> value;
    private final Optional<VarAdmin> var;
    private static final String[] VALUE_PROPERTIES = (String[])ResourceType.DataType.SUPPORTED_TYPES.values().stream().map(ResourceType.DataType::getConceptProperty).distinct().map(Enum::name).toArray(String[]::new);

    ComparatorPredicate(Object value) {
        if (value instanceof VarAdmin) {
            this.value = Optional.empty();
            this.var = Optional.of((VarAdmin)value);
        } else {
            this.value = Optional.of(value);
            this.var = Optional.empty();
        }
    }

    ComparatorPredicate(Var var) {
        this.value = Optional.empty();
        this.var = Optional.of(var.admin());
    }

    protected abstract String getSymbol();

    abstract <V> P<V> gremlinPredicate(V var1);

    public String toString() {
        String argument = this.value.map(StringConverter::valueToString).orElseGet(() -> this.var.get().getPrintableName());
        return this.getSymbol() + " " + argument;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparatorPredicate that = (ComparatorPredicate)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public Optional<P<Object>> getPredicate() {
        return this.value.map(this::gremlinPredicate);
    }

    public Optional<VarAdmin> getInnerVar() {
        return this.var;
    }

    public final void applyPredicate(GraphTraversal<Vertex, Vertex> traversal) {
        this.var.ifPresent(theVar -> {
            String thisVar = UUID.randomUUID().toString();
            VarName otherVar = theVar.getVarName();
            String otherValue = UUID.randomUUID().toString();
            Traversal[] traversals = (Traversal[])Stream.of(VALUE_PROPERTIES).map(prop -> __.values((String[])new String[]{prop}).as(otherValue, new String[0]).select(thisVar).values(new String[]{prop}).where(this.gremlinPredicate(otherValue))).toArray(Traversal[]::new);
            traversal.as(thisVar, new String[0]).select(otherVar.getValue()).or(traversals).select(thisVar);
        });
        this.value.ifPresent(theValue -> {
            ResourceType.DataType dataType = (ResourceType.DataType)ResourceType.DataType.SUPPORTED_TYPES.get(theValue.getClass().getTypeName());
            Schema.ConceptProperty property = dataType.getConceptProperty();
            traversal.has(property.name(), this.gremlinPredicate(theValue));
        });
    }
}

