/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Rule;
import ai.grakn.concept.Type;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.util.Pair;

public class Utility {
    private static final String CAPTURE_MARK = "captured-";
    public static final Function<RoleType, Set<RelationType>> roleToRelationTypes = role -> role.relationTypes().stream().filter(rt -> rt.isImplicit() == false).collect(Collectors.toSet());
    public static final Function<Type, Set<RelationType>> typeToRelationTypes = type -> type.playsRoles().stream().flatMap(roleType -> roleType.relationTypes().stream()).filter(rt -> rt.isImplicit() == false).collect(Collectors.toSet());

    public static VarName capture(VarName var) {
        return var.map(CAPTURE_MARK::concat);
    }

    public static VarName uncapture(VarName var) {
        return var.map(name -> name.replace(CAPTURE_MARK, ""));
    }

    public static boolean isCaptured(VarName var) {
        return var.getValue().contains(CAPTURE_MARK);
    }

    public static void printAnswers(Set<Map<String, Concept>> answers) {
        answers.forEach(result -> {
            result.entrySet().forEach(entry -> {
                Concept concept = (Concept)entry.getValue();
                System.out.print((String)entry.getKey() + ": " + concept.getId() + " : ");
                if (concept.isResource()) {
                    System.out.print(concept.asResource().getValue() + " ");
                }
            });
            System.out.println();
        });
        System.out.println();
    }

    public static Set<RoleType> getCompatibleRoleTypes(Type type, Type relType) {
        HashSet<RoleType> cRoles = new HashSet<RoleType>();
        Collection typeRoles = type.playsRoles();
        Collection relRoles = ((RelationType)relType).hasRoles();
        relRoles.stream().filter(typeRoles::contains).forEach(cRoles::add);
        return cRoles;
    }

    public static <T extends Type> Set<RelationType> getCompatibleRelationTypes(Set<T> types, Function<T, Set<RelationType>> typeMapper) {
        HashSet<RelationType> compatibleTypes = new HashSet<RelationType>();
        if (types.isEmpty()) {
            return compatibleTypes;
        }
        Iterator<T> it = types.iterator();
        compatibleTypes.addAll((Collection<RelationType>)typeMapper.apply(it.next()));
        while (it.hasNext() && compatibleTypes.size() > 1) {
            compatibleTypes.retainAll((Collection)typeMapper.apply(it.next()));
        }
        return compatibleTypes;
    }

    public static void computeRoleCombinations(Set<VarName> vars, Set<RoleType> roles, Map<VarName, VarAdmin> roleMap, Set<Map<VarName, Var>> roleMaps) {
        HashSet tempVars = Sets.newHashSet(vars);
        HashSet tempRoles = Sets.newHashSet(roles);
        VarName var = vars.iterator().next();
        roles.forEach(role -> {
            tempVars.remove(var);
            tempRoles.remove(role);
            roleMap.put(var, Graql.var().name(role.getName()).admin());
            if (!tempVars.isEmpty() && !tempRoles.isEmpty()) {
                Utility.computeRoleCombinations(tempVars, tempRoles, roleMap, roleMaps);
            } else {
                if (!roleMap.isEmpty()) {
                    roleMaps.add(Maps.newHashMap((Map)roleMap));
                }
                roleMap.remove(var);
            }
            tempVars.add(var);
            tempRoles.add(role);
        });
    }

    public static VarName createFreshVariable(Set<VarName> vars, VarName var) {
        Set names = vars.stream().map(VarName::getValue).collect(Collectors.toSet());
        String fresh = var.getValue();
        while (names.contains(fresh)) {
            String valFree = fresh.replaceAll("[^0-9]", "");
            int value = valFree.equals("") ? 0 : Integer.parseInt(valFree);
            fresh = fresh.replaceAll("\\d+", "") + ++value;
        }
        return Patterns.varName(fresh);
    }

    public static Rule createTransitiveRule(RelationType relType, String fromRoleName, String toRoleName, GraknGraph graph) {
        int arity = relType.hasRoles().size();
        if (arity != 2) {
            throw new IllegalArgumentException(ErrorMessage.RULE_CREATION_ARITY_ERROR.getMessage(new Object[0]));
        }
        VarAdmin startVar = Graql.var().isa(relType.getName()).rel(fromRoleName, "x").rel(toRoleName, "z").admin();
        VarAdmin endVar = Graql.var().isa(relType.getName()).rel(fromRoleName, "z").rel(toRoleName, "y").admin();
        VarAdmin headVar = Graql.var().isa(relType.getName()).rel(fromRoleName, "x").rel(toRoleName, "y").admin();
        Conjunction body = Patterns.conjunction(Sets.newHashSet((Object[])new VarAdmin[]{startVar, endVar}));
        return graph.admin().getMetaRuleInference().addRule(body, (Pattern)headVar);
    }

    public static Rule createReflexiveRule(RelationType relType, GraknGraph graph) {
        int arity = relType.hasRoles().size();
        if (arity != 2) {
            throw new IllegalArgumentException(ErrorMessage.RULE_CREATION_ARITY_ERROR.getMessage(new Object[0]));
        }
        Var body = Graql.var().isa(relType.getName()).rel("x").rel("y");
        Var head = Graql.var().isa(relType.getName()).rel("x").rel("x");
        return graph.admin().getMetaRuleInference().addRule((Pattern)body, (Pattern)head);
    }

    public static Rule createSubPropertyRule(RelationType parent, RelationType child, Map<String, String> roleMappings, GraknGraph graph) {
        int childArity;
        int parentArity = parent.hasRoles().size();
        if (parentArity != (childArity = child.hasRoles().size()) || parentArity != roleMappings.size()) {
            throw new IllegalArgumentException(ErrorMessage.RULE_CREATION_ARITY_ERROR.getMessage(new Object[0]));
        }
        Var parentVar = Graql.var().isa(parent.getName());
        Var childVar = Graql.var().isa(child.getName());
        HashSet vars = new HashSet();
        roleMappings.forEach((parentRoleName, childRoleName) -> {
            VarName varName = Utility.createFreshVariable(vars, Patterns.varName("x"));
            parentVar.rel(parentRoleName, Graql.var(varName));
            childVar.rel(childRoleName, Graql.var(varName));
            vars.add(varName);
        });
        return graph.admin().getMetaRuleInference().addRule((Pattern)childVar, (Pattern)parentVar);
    }

    public static Rule createPropertyChainRule(RelationType relation, String fromRoleName, String toRoleName, LinkedHashMap<RelationType, Pair<String, String>> chain, GraknGraph graph) {
        Stack<VarName> varNames = new Stack<VarName>();
        varNames.push(Patterns.varName("x"));
        HashSet bodyVars = new HashSet();
        chain.forEach((relType, rolePair) -> {
            VarName varName = Utility.createFreshVariable(Sets.newHashSet((Iterable)varNames), Patterns.varName("x"));
            VarAdmin var = Graql.var().isa(relType.getName()).rel((String)rolePair.getKey(), Graql.var((VarName)varNames.peek())).rel((String)rolePair.getValue(), Graql.var(varName)).admin();
            varNames.push(varName);
            bodyVars.add(var);
        });
        Var headVar = Graql.var().isa(relation.getName()).rel(fromRoleName, "x").rel(toRoleName, Graql.var((VarName)varNames.peek()));
        return graph.admin().getMetaRuleInference().addRule(Patterns.conjunction(bodyVars), (Pattern)headVar);
    }

    public static Set<RoleType> getNonMetaSuperRoleTypes(RoleType role) {
        HashSet<RoleType> roles = new HashSet<RoleType>();
        RoleType baseRole = role.superType();
        while (!Schema.MetaSchema.isMetaName((String)baseRole.getName())) {
            roles.add(baseRole);
            baseRole = baseRole.superType();
        }
        return roles;
    }

    public static RoleType getNonMetaTopRole(RoleType role) {
        RoleType topRole = role;
        RoleType superRole = topRole.superType();
        while (!Schema.MetaSchema.isMetaName((String)superRole.getName())) {
            topRole = superRole;
            superRole = superRole.superType();
        }
        return topRole;
    }

    public static boolean checkTypesCompatible(Type parent, Type child) {
        return parent.equals(child) || parent.subTypes().contains(child);
    }

    public static <T> Set<T> subtractSets(Set<T> A, Set<T> B) {
        HashSet sub;
        HashSet hashSet = sub = A.size() > B.size() ? Sets.newHashSet(A) : Sets.newHashSet(B);
        if (A.size() > B.size()) {
            sub.removeAll(B);
        } else {
            sub.removeAll(A);
        }
        return sub;
    }
}

