/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom;

import ai.grakn.GraknGraph;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Rule;
import ai.grakn.concept.Type;
import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.reasoner.Reasoner;
import ai.grakn.graql.internal.reasoner.atom.AtomBase;
import ai.grakn.graql.internal.reasoner.atom.binary.Binary;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.query.Query;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.util.Pair;

public abstract class Atom
extends AtomBase {
    protected Type type = null;
    protected ConceptId typeId = null;

    protected Atom(VarAdmin pattern) {
        this(pattern, null);
    }

    protected Atom(VarAdmin pattern, Query par) {
        super(pattern, par);
    }

    protected Atom(Atom a) {
        super(a);
        this.type = a.type;
        this.typeId = a.getTypeId() != null ? ConceptId.of((String)a.getTypeId().getValue()) : null;
    }

    @Override
    public boolean isAtom() {
        return true;
    }

    public boolean isBinary() {
        return false;
    }

    public boolean isType() {
        return false;
    }

    public boolean isRelation() {
        return false;
    }

    public boolean isResource() {
        return false;
    }

    protected abstract boolean isRuleApplicable(InferenceRule var1);

    public Set<Rule> getApplicableRules() {
        HashSet<Rule> children = new HashSet<Rule>();
        GraknGraph graph = this.getParentQuery().graph();
        Collection<Object> rulesFromType = this.getType() != null ? this.getType().getRulesOfConclusion() : Reasoner.getRules(graph);
        rulesFromType.forEach(rule -> {
            InferenceRule child = new InferenceRule((Rule)rule, graph);
            boolean ruleRelevant = this.isRuleApplicable(child);
            if (ruleRelevant) {
                children.add((Rule)rule);
            }
        });
        return children;
    }

    @Override
    public boolean isRuleResolvable() {
        Type type = this.getType();
        return type != null && !type.getRulesOfConclusion().isEmpty() && !this.getApplicableRules().isEmpty();
    }

    @Override
    public boolean isRecursive() {
        if (this.isResource() || this.getType() == null) {
            return false;
        }
        boolean atomRecursive = false;
        Type type = this.getType();
        Collection presentInConclusion = type.getRulesOfConclusion();
        Collection presentInHypothesis = type.getRulesOfHypothesis();
        for (Rule rule : presentInConclusion) {
            atomRecursive |= presentInHypothesis.contains(rule);
        }
        return atomRecursive;
    }

    public boolean requiresMaterialisation() {
        return false;
    }

    public Type getType() {
        if (this.type == null && this.typeId != null) {
            this.type = this.getParentQuery().graph().getConcept(this.typeId).asType();
        }
        return this.type;
    }

    public ConceptId getTypeId() {
        return this.typeId;
    }

    public VarName getValueVariable() {
        throw new IllegalArgumentException("getValueVariable called on Atom object " + this.getPattern());
    }

    public abstract Set<Predicate> getPredicates();

    public abstract Set<Predicate> getIdPredicates();

    public abstract Set<Predicate> getValuePredicates();

    public Set<Atom> getTypeConstraints() {
        HashSet<Atom> relevantTypes = new HashSet<Atom>();
        this.getParentQuery().getTypeConstraints().stream().filter(atom -> this.containsVar(atom.getVarName())).forEach(atom -> {
            relevantTypes.add((Atom)atom);
            relevantTypes.addAll(((Binary)atom).getLinkedAtoms());
        });
        return relevantTypes;
    }

    public Map<VarName, Pair<Type, RoleType>> getVarTypeRoleMap() {
        HashMap<VarName, Pair<Type, RoleType>> roleVarTypeMap = new HashMap<VarName, Pair<Type, RoleType>>();
        if (this.getParentQuery() == null) {
            return roleVarTypeMap;
        }
        Set<VarName> vars = this.getVarNames();
        Map<VarName, Type> varTypeMap = this.getParentQuery().getVarTypeMap();
        vars.forEach(var -> {
            Type type = (Type)varTypeMap.get(var);
            roleVarTypeMap.put((VarName)var, (Pair<Type, RoleType>)new Pair((Object)type, null));
        });
        return roleVarTypeMap;
    }

    public Map<RoleType, Pair<VarName, Type>> getRoleVarTypeMap() {
        return new HashMap<RoleType, Pair<VarName, Type>>();
    }

    public void inferTypes() {
    }

    public Pair<Atom, Map<VarName, VarName>> rewrite(Atom parent, Query q) {
        return new Pair((Object)this, new HashMap());
    }
}

