/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom;

import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.reasoner.Utility;
import ai.grakn.graql.internal.reasoner.atom.Atomic;
import ai.grakn.graql.internal.reasoner.query.Query;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AtomBase
implements Atomic {
    protected VarName varName = null;
    protected PatternAdmin atomPattern = null;
    private Query parent = null;

    protected AtomBase(VarAdmin pattern, Query par) {
        this.atomPattern = pattern;
        this.varName = pattern.getVarName();
        this.parent = par;
    }

    protected AtomBase(AtomBase a) {
        this.atomPattern = Patterns.copyOf(a.atomPattern.asVar());
        this.varName = this.atomPattern.asVar().getVarName();
    }

    @Override
    public abstract Atomic clone();

    public String toString() {
        return this.atomPattern.toString();
    }

    @Override
    public boolean containsVar(VarName name) {
        return this.getVarNames().contains(name);
    }

    @Override
    public boolean isUserDefinedName() {
        return this.atomPattern.asVar().isUserDefinedName();
    }

    @Override
    public VarName getVarName() {
        return this.varName;
    }

    @Override
    public Set<VarName> getVarNames() {
        return Sets.newHashSet((Object[])new VarName[]{this.varName});
    }

    public Set<VarName> getSelectedNames() {
        Set<VarName> vars = this.getParentQuery().getSelectedNames();
        vars.retainAll(this.getVarNames());
        return vars;
    }

    public void resetNames() {
        HashMap<VarName, VarName> unifiers = new HashMap<VarName, VarName>();
        this.getVarNames().forEach(var -> unifiers.put((VarName)var, Patterns.varName()));
        this.unify(unifiers);
    }

    public boolean isValueUserDefinedName() {
        return false;
    }

    @Override
    public PatternAdmin getPattern() {
        return this.atomPattern;
    }

    @Override
    public PatternAdmin getCombinedPattern() {
        return this.getPattern();
    }

    @Override
    public Query getParentQuery() {
        return this.parent;
    }

    @Override
    public void setParentQuery(Query q) {
        this.parent = q;
    }

    private void setVarName(VarName var) {
        this.varName = var;
        this.atomPattern.asVar().setVarName(var);
    }

    @Override
    public void unify(Map<VarName, VarName> unifiers) {
        VarName var = this.getVarName();
        if (unifiers.containsKey(var)) {
            this.setVarName(unifiers.get(var));
        } else if (unifiers.containsValue(var)) {
            this.setVarName(Utility.capture(var));
        }
    }

    @Override
    public Map<VarName, VarName> getUnifiers(Atomic parentAtom) {
        if (parentAtom.getClass() != this.getClass()) {
            throw new IllegalArgumentException(ErrorMessage.UNIFICATION_ATOM_INCOMPATIBILITY.getMessage(new Object[0]));
        }
        HashMap<VarName, VarName> map = new HashMap<VarName, VarName>();
        if (!this.getVarName().equals(parentAtom.getVarName())) {
            map.put(this.getVarName(), parentAtom.getVarName());
        }
        return map;
    }
}

