/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom;

import ai.grakn.concept.Concept;
import ai.grakn.graql.Graql;
import ai.grakn.graql.VarName;
import ai.grakn.graql.internal.pattern.property.NeqProperty;
import ai.grakn.graql.internal.reasoner.Utility;
import ai.grakn.graql.internal.reasoner.atom.AtomBase;
import ai.grakn.graql.internal.reasoner.atom.Atomic;
import ai.grakn.graql.internal.reasoner.query.Query;
import ai.grakn.graql.internal.reasoner.query.QueryAnswers;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;

public class NotEquals
extends AtomBase {
    private VarName refVarName;
    public static BiFunction<Map<VarName, Concept>, NotEquals, Stream<Map<VarName, Concept>>> notEqualsFunction = (a, atom) -> NotEquals.notEqualsOperator(a, atom) ? Stream.empty() : Stream.of(a);

    public NotEquals(VarName varName, NeqProperty prop, Query parent) {
        super(Graql.var(varName).neq(Graql.var(prop.getVar().getVarName())).admin(), parent);
        this.refVarName = prop.getVar().getVarName();
    }

    public NotEquals(NotEquals a) {
        super(a);
        this.refVarName = a.getReferenceVarName();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        NotEquals a2 = (NotEquals)obj;
        return this.getVarName().equals(a2.getVarName()) && this.getReferenceVarName().equals(a2.getReferenceVarName());
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + this.varName.hashCode();
        hashCode = hashCode * 37 + this.refVarName.hashCode();
        return hashCode;
    }

    @Override
    public boolean isEquivalent(Object obj) {
        return true;
    }

    @Override
    public int equivalenceHashCode() {
        return 1;
    }

    @Override
    public Atomic clone() {
        return new NotEquals(this);
    }

    private void setRefVarName(VarName var) {
        this.refVarName = var;
        this.atomPattern = Graql.var(this.varName).neq(Graql.var(var)).admin();
    }

    @Override
    public void unify(Map<VarName, VarName> unifiers) {
        super.unify(unifiers);
        VarName var = this.getReferenceVarName();
        if (unifiers.containsKey(var)) {
            this.setRefVarName(unifiers.get(var));
        } else if (unifiers.containsValue(var)) {
            this.setRefVarName(Utility.capture(var));
        }
    }

    public VarName getReferenceVarName() {
        return this.refVarName;
    }

    public static boolean notEqualsOperator(Map<VarName, Concept> answer, NotEquals atom) {
        return answer.get(atom.varName).equals(answer.get(atom.refVarName));
    }

    public QueryAnswers filter(QueryAnswers answers) {
        QueryAnswers results = new QueryAnswers();
        answers.stream().filter((? super T answer) -> !((Concept)answer.get(this.varName)).equals(answer.get(this.refVarName))).forEach(results::add);
        return results;
    }

    public Stream<Map<VarName, Concept>> filter(Stream<Map<VarName, Concept>> answers) {
        return answers.filter((? super T answer) -> !((Concept)answer.get(this.varName)).equals(answer.get(this.refVarName)));
    }
}

