/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.concept.ConceptId;
import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.reasoner.atom.AtomicFactory;
import ai.grakn.graql.internal.reasoner.atom.binary.BinaryBase;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.query.Query;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;

public abstract class Binary
extends BinaryBase {
    private IdPredicate predicate = null;

    protected Binary(VarAdmin pattern, IdPredicate p, Query par) {
        super(pattern, par);
        this.predicate = p;
        this.typeId = this.extractTypeId(this.atomPattern.asVar());
    }

    protected Binary(Binary a) {
        super(a);
        this.predicate = a.getPredicate() != null ? (IdPredicate)AtomicFactory.create(a.getPredicate(), this.getParentQuery()) : null;
        this.typeId = a.getTypeId() != null ? ConceptId.of((String)a.getTypeId().getValue()) : null;
    }

    protected abstract ConceptId extractTypeId(VarAdmin var1);

    @Override
    public PatternAdmin getCombinedPattern() {
        HashSet vars = Sets.newHashSet((Object[])new VarAdmin[]{super.getPattern().asVar()});
        if (this.getPredicate() != null) {
            vars.add(this.getPredicate().getPattern().asVar());
        }
        return Patterns.conjunction(vars);
    }

    @Override
    public void setParentQuery(Query q) {
        super.setParentQuery(q);
        if (this.predicate != null) {
            this.predicate.setParentQuery(q);
        }
    }

    public IdPredicate getPredicate() {
        return this.predicate;
    }

    protected void setPredicate(IdPredicate p) {
        this.predicate = p;
    }

    @Override
    protected boolean predicatesEquivalent(BinaryBase atom) {
        IdPredicate pred = this.getPredicate();
        IdPredicate objPredicate = ((Binary)atom).getPredicate();
        return pred == null && objPredicate == null || pred != null && pred.isEquivalent(objPredicate);
    }

    @Override
    public int equivalenceHashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + (this.typeId != null ? this.typeId.hashCode() : 0);
        hashCode = hashCode * 37 + (this.predicate != null ? this.predicate.equivalenceHashCode() : 0);
        return hashCode;
    }

    @Override
    public boolean isValueUserDefinedName() {
        return this.predicate == null && !this.getValueVariable().getValue().isEmpty();
    }

    @Override
    public void unify(Map<VarName, VarName> unifiers) {
        super.unify(unifiers);
        if (this.predicate != null) {
            this.predicate.unify(unifiers);
        }
    }
}

