/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.reasoner.Utility;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.Atomic;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.query.Query;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.util.ErrorMessage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class BinaryBase
extends Atom {
    private VarName valueVariable;

    protected BinaryBase(VarAdmin pattern, Query par) {
        super(pattern, par);
        this.valueVariable = this.extractValueVariableName(pattern);
    }

    protected BinaryBase(BinaryBase a) {
        super(a);
        this.valueVariable = a.getValueVariable();
    }

    protected abstract VarName extractValueVariableName(VarAdmin var1);

    protected abstract boolean predicatesEquivalent(BinaryBase var1);

    @Override
    public VarName getValueVariable() {
        return this.valueVariable;
    }

    protected void setValueVariable(VarName var) {
        this.valueVariable = var;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    protected boolean isRuleApplicable(InferenceRule child) {
        Atom ruleAtom = child.getHead().getAtom();
        return ruleAtom instanceof BinaryBase && this.getType().equals(ruleAtom.getType());
    }

    @Override
    public boolean requiresMaterialisation() {
        return this.isUserDefinedName() && this.getType() != null && this.getType().isRelationType();
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + (this.typeId != null ? this.typeId.hashCode() : 0);
        hashCode = hashCode * 37 + this.varName.hashCode();
        hashCode = hashCode * 37 + this.valueVariable.hashCode();
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        BinaryBase a2 = (BinaryBase)obj;
        return Objects.equals(this.typeId, a2.getTypeId()) && this.varName.equals(a2.getVarName()) && this.valueVariable.equals(a2.getValueVariable());
    }

    @Override
    public boolean isEquivalent(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        BinaryBase a2 = (BinaryBase)obj;
        return Objects.equals(this.typeId, a2.getTypeId()) && this.predicatesEquivalent(a2);
    }

    @Override
    public Set<Predicate> getIdPredicates() {
        return this.getParentQuery().getIdPredicates().stream().filter(atom -> this.containsVar(atom.getVarName())).collect(Collectors.toSet());
    }

    @Override
    public Set<Predicate> getValuePredicates() {
        return new HashSet<Predicate>();
    }

    @Override
    public Set<Predicate> getPredicates() {
        Set<Predicate> predicates = this.getValuePredicates();
        predicates.addAll(this.getIdPredicates());
        return predicates;
    }

    public Set<Atom> getLinkedAtoms() {
        HashSet<Atom> atoms = new HashSet<Atom>();
        this.getParentQuery().getAtoms().stream().filter(Atomic::isAtom).map(atom -> (Atom)atom).filter(Atom::isBinary).map(atom -> (BinaryBase)atom).filter(atom -> atom.getVarName().equals(this.valueVariable)).forEach(atom -> {
            atoms.add((Atom)atom);
            atoms.addAll(atom.getLinkedAtoms());
        });
        return atoms;
    }

    @Override
    public Set<VarName> getVarNames() {
        HashSet<VarName> vars = new HashSet<VarName>();
        if (this.isUserDefinedName()) {
            vars.add(this.getVarName());
        }
        if (!this.valueVariable.getValue().isEmpty()) {
            vars.add(this.valueVariable);
        }
        return vars;
    }

    @Override
    public Set<VarName> getSelectedNames() {
        Set<VarName> vars = super.getSelectedNames();
        if (this.isUserDefinedName()) {
            vars.add(this.getVarName());
        }
        if (this.isValueUserDefinedName()) {
            vars.add(this.getValueVariable());
        }
        return vars;
    }

    @Override
    public void unify(Map<VarName, VarName> unifiers) {
        super.unify(unifiers);
        VarName var = this.valueVariable;
        if (unifiers.containsKey(var)) {
            this.setValueVariable(unifiers.get(var));
        } else if (unifiers.containsValue(var)) {
            this.setValueVariable(Utility.capture(var));
        }
    }

    @Override
    public Map<VarName, VarName> getUnifiers(Atomic parentAtom) {
        VarName parentVarName;
        VarName childVarName;
        if (!(parentAtom instanceof BinaryBase)) {
            throw new IllegalArgumentException(ErrorMessage.UNIFICATION_ATOM_INCOMPATIBILITY.getMessage(new Object[0]));
        }
        HashMap<VarName, VarName> unifiers = new HashMap<VarName, VarName>();
        VarName childValVarName = this.getValueVariable();
        VarName parentValVarName = ((BinaryBase)parentAtom).getValueVariable();
        if (parentAtom.isUserDefinedName() && !(childVarName = this.getVarName()).equals(parentVarName = parentAtom.getVarName())) {
            unifiers.put(childVarName, parentVarName);
        }
        if (!parentValVarName.getValue().isEmpty() && !childValVarName.equals(parentValVarName)) {
            unifiers.put(childValVarName, parentValVarName);
        }
        return unifiers;
    }
}

