/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.concept.ConceptId;
import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.reasoner.atom.AtomBase;
import ai.grakn.graql.internal.reasoner.atom.AtomicFactory;
import ai.grakn.graql.internal.reasoner.atom.binary.BinaryBase;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.query.Query;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class MultiPredicateBinary
extends BinaryBase {
    private final Set<Predicate> multiPredicate = new HashSet<Predicate>();

    protected MultiPredicateBinary(VarAdmin pattern, Set<Predicate> preds, Query par) {
        super(pattern, par);
        this.multiPredicate.addAll(preds);
        this.typeId = this.extractTypeId(this.atomPattern.asVar());
    }

    protected MultiPredicateBinary(MultiPredicateBinary a) {
        super(a);
        a.getMultiPredicate().forEach(pred -> this.multiPredicate.add((Predicate)AtomicFactory.create(pred, this.getParentQuery())));
        this.typeId = a.getTypeId() != null ? ConceptId.of((String)a.getTypeId().getValue()) : null;
    }

    protected abstract ConceptId extractTypeId(VarAdmin var1);

    @Override
    public void setParentQuery(Query q) {
        super.setParentQuery(q);
        this.multiPredicate.forEach(pred -> pred.setParentQuery(q));
    }

    public Set<Predicate> getMultiPredicate() {
        return this.multiPredicate;
    }

    @Override
    public PatternAdmin getCombinedPattern() {
        Set vars = this.getMultiPredicate().stream().map(AtomBase::getPattern).map(PatternAdmin::asVar).collect(Collectors.toSet());
        vars.add(super.getPattern().asVar());
        return Patterns.conjunction(vars);
    }

    @Override
    protected boolean predicatesEquivalent(BinaryBase at) {
        MultiPredicateBinary atom = (MultiPredicateBinary)at;
        boolean predicatesEquivalent = true;
        Iterator<Predicate> it = this.getMultiPredicate().iterator();
        while (it.hasNext() && predicatesEquivalent) {
            Iterator<Predicate> objIt = atom.getMultiPredicate().iterator();
            boolean predicateHasEquivalent = false;
            while (objIt.hasNext() && !predicateHasEquivalent) {
                predicateHasEquivalent = it.next().isEquivalent(objIt.next());
            }
            predicatesEquivalent = predicateHasEquivalent;
        }
        return predicatesEquivalent;
    }

    private int multiPredicateEquivalenceHashCode() {
        int hashCode = 0;
        for (Predicate aMultiPredicate : this.multiPredicate) {
            hashCode += aMultiPredicate.equivalenceHashCode();
        }
        return hashCode;
    }

    @Override
    public int equivalenceHashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + (this.typeId != null ? this.typeId.hashCode() : 0);
        hashCode = hashCode * 37 + this.multiPredicateEquivalenceHashCode();
        return hashCode;
    }

    @Override
    public boolean isValueUserDefinedName() {
        return this.multiPredicate.isEmpty();
    }

    @Override
    public void unify(Map<VarName, VarName> unifiers) {
        super.unify(unifiers);
        this.multiPredicate.forEach(predicate -> predicate.unify(unifiers));
    }
}

