/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Rule;
import ai.grakn.concept.Type;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.RelationPlayer;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.pattern.property.RelationProperty;
import ai.grakn.graql.internal.reasoner.Reasoner;
import ai.grakn.graql.internal.reasoner.Utility;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.Atomic;
import ai.grakn.graql.internal.reasoner.atom.binary.HasRole;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.query.AtomicMatchQuery;
import ai.grakn.graql.internal.reasoner.query.Query;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javafx.util.Pair;

public class Relation
extends TypeAtom {
    private Set<RelationPlayer> relationPlayers;
    private Map<RoleType, Pair<VarName, Type>> roleVarTypeMap = null;
    private Map<VarName, Pair<Type, RoleType>> varTypeRoleMap = null;

    public Relation(VarAdmin pattern) {
        this(pattern, null, null);
    }

    public Relation(VarAdmin pattern, Query par) {
        this(pattern, null, par);
    }

    public Relation(VarAdmin pattern, IdPredicate predicate, Query par) {
        super(pattern, predicate, par);
        this.relationPlayers = this.getRelationPlayers(pattern);
    }

    public Relation(VarName name, VarName typeVariable, Map<VarName, Var> roleMap, IdPredicate pred, Query par) {
        super(Relation.constructRelationVar(name, typeVariable, roleMap), pred, par);
        this.relationPlayers = this.getRelationPlayers(this.getPattern().asVar());
    }

    private Relation(Relation a) {
        super(a);
        this.relationPlayers = this.getRelationPlayers();
        this.roleVarTypeMap = a.roleVarTypeMap != null ? Maps.newHashMap(a.roleVarTypeMap) : null;
        this.varTypeRoleMap = a.varTypeRoleMap != null ? Maps.newHashMap(a.varTypeRoleMap) : null;
    }

    private Set<RelationPlayer> getRelationPlayers() {
        return this.getRelationPlayers(this.atomPattern.asVar());
    }

    private Set<RelationPlayer> getRelationPlayers(VarAdmin pattern) {
        HashSet<RelationPlayer> rps = new HashSet<RelationPlayer>();
        pattern.getProperty(RelationProperty.class).ifPresent(prop -> prop.getRelationPlayers().forEach(rps::add));
        return rps;
    }

    @Override
    protected VarName extractValueVariableName(VarAdmin var) {
        IsaProperty isaProp = var.getProperty(IsaProperty.class).orElse(null);
        return isaProp != null ? isaProp.getType().getVarName() : Patterns.varName("");
    }

    @Override
    protected void setValueVariable(VarName var) {
        IsaProperty isaProp = this.atomPattern.asVar().getProperty(IsaProperty.class).orElse(null);
        if (isaProp != null) {
            super.setValueVariable(var);
            this.atomPattern.asVar().getProperties(IsaProperty.class).forEach(prop -> prop.getType().setVarName(var));
        }
    }

    @Override
    public Atomic clone() {
        return new Relation(this);
    }

    private static VarAdmin constructRelationVar(VarName varName, VarName typeVariable, Map<VarName, Var> roleMap) {
        Var var = !varName.getValue().isEmpty() ? Graql.var(varName) : Graql.var();
        roleMap.forEach((player, role) -> {
            if (role == null) {
                var.rel(Graql.var(player));
            } else {
                var.rel(role, Graql.var(player));
            }
        });
        var.isa(Graql.var(typeVariable));
        return var.admin().asVar();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Relation a2 = (Relation)obj;
        return Objects.equals(this.typeId, a2.getTypeId()) && this.getVarNames().equals(a2.getVarNames()) && this.relationPlayers.equals(a2.relationPlayers);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + (this.getTypeId() != null ? this.getTypeId().hashCode() : 0);
        hashCode = hashCode * 37 + this.getVarNames().hashCode();
        return hashCode;
    }

    @Override
    public boolean isEquivalent(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Relation a2 = (Relation)obj;
        Map<RoleType, String> map = this.getRoleConceptIdMap();
        Map<RoleType, String> map2 = a2.getRoleConceptIdMap();
        return Objects.equals(this.typeId, a2.getTypeId()) && map.equals(map2);
    }

    @Override
    public int equivalenceHashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + (this.typeId != null ? this.typeId.hashCode() : 0);
        hashCode = hashCode * 37 + this.getRoleConceptIdMap().hashCode();
        return hashCode;
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    private boolean isRuleApplicableViaType(RelationType relType) {
        boolean ruleRelevant = true;
        Map<VarName, Type> varTypeMap = this.getParentQuery().getVarTypeMap();
        Iterator it = varTypeMap.entrySet().stream().filter(entry -> this.containsVar((VarName)entry.getKey())).iterator();
        while (it.hasNext() && ruleRelevant) {
            Map.Entry entry2 = (Map.Entry)it.next();
            Type type = (Type)entry2.getValue();
            if (type == null) continue;
            Collection roleIntersection = relType.hasRoles();
            roleIntersection.retainAll(type.playsRoles());
            ruleRelevant = !roleIntersection.isEmpty();
        }
        return ruleRelevant;
    }

    private boolean isRuleApplicableViaAtom(Atom childAtom, InferenceRule child) {
        boolean ruleRelevant = true;
        Query parent = this.getParentQuery();
        Map<RoleType, Pair<VarName, Type>> childRoleVarTypeMap = childAtom.getRoleVarTypeMap();
        Map<RoleType, Pair<VarName, Type>> parentRoleVarTypeMap = this.getRoleVarTypeMap();
        Iterator<Map.Entry<RoleType, Pair<VarName, Type>>> it = parentRoleVarTypeMap.entrySet().iterator();
        while (it.hasNext() && ruleRelevant) {
            Type chType;
            boolean roleCompatible;
            Map.Entry<RoleType, Pair<VarName, Type>> entry = it.next();
            RoleType parentRole = entry.getKey();
            Iterator<RoleType> childRolesIt = childRoleVarTypeMap.keySet().iterator();
            boolean bl = roleCompatible = !childRolesIt.hasNext();
            while (childRolesIt.hasNext() && !roleCompatible) {
                roleCompatible = Utility.checkTypesCompatible((Type)parentRole, (Type)childRolesIt.next());
            }
            ruleRelevant = roleCompatible;
            Type pType = (Type)entry.getValue().getValue();
            if (pType == null || !ruleRelevant || !childRoleVarTypeMap.containsKey(parentRole) || (chType = (Type)childRoleVarTypeMap.get(parentRole).getValue()) == null) continue;
            ruleRelevant = Utility.checkTypesCompatible(pType, chType);
            VarName chVar = (VarName)childRoleVarTypeMap.get(parentRole).getKey();
            VarName pVar = (VarName)entry.getValue().getKey();
            IdPredicate childPredicate = child.getBody().getIdPredicate(chVar);
            IdPredicate parentPredicate = parent.getIdPredicate(pVar);
            if (childPredicate == null || parentPredicate == null) continue;
            ruleRelevant &= ((Predicate)childPredicate).getPredicateValue().equals(((Predicate)parentPredicate).getPredicateValue());
        }
        return ruleRelevant;
    }

    @Override
    protected boolean isRuleApplicable(InferenceRule child) {
        Atom ruleAtom = child.getRuleConclusionAtom();
        if (!(ruleAtom instanceof Relation)) {
            return false;
        }
        Relation childAtom = (Relation)ruleAtom;
        if (childAtom.getRelationPlayers().size() < this.getRelationPlayers().size()) {
            return false;
        }
        Type type = this.getType();
        if (type == null) {
            return this.isRuleApplicableViaType((RelationType)childAtom.getType());
        }
        return this.isRuleApplicableViaAtom(childAtom, child);
    }

    @Override
    public boolean isRuleResolvable() {
        Type t = this.getType();
        if (t != null) {
            return !t.getRulesOfConclusion().isEmpty() && !this.getApplicableRules().isEmpty();
        }
        GraknGraph graph = this.getParentQuery().graph();
        Set<Rule> rules = Reasoner.getRules(graph);
        return rules.stream().flatMap(rule -> rule.getConclusionTypes().stream()).filter(Concept::isRelationType).count() != 0L & !this.getApplicableRules().isEmpty();
    }

    private Set<RoleType> getExplicitRoleTypes() {
        HashSet<RoleType> roleTypes = new HashSet<RoleType>();
        GraknGraph graph = this.getParentQuery().graph();
        this.relationPlayers.stream().map(RelationPlayer::getRoleType).flatMap(CommonUtil::optionalToStream).map(VarAdmin::getTypeName).flatMap(CommonUtil::optionalToStream).map(arg_0 -> ((GraknGraph)graph).getRoleType(arg_0)).forEach(roleTypes::add);
        return roleTypes;
    }

    private void addPredicate(IdPredicate pred) {
        if (this.getParentQuery() == null) {
            throw new IllegalStateException("No parent in addPredicate");
        }
        Query parent = this.getParentQuery();
        pred.setParentQuery(parent);
        this.setPredicate(pred);
        this.getParentQuery().addAtom(pred);
    }

    private void addType(Type type) {
        this.typeId = type.getId();
        VarName typeVariable = Patterns.varName("rel-" + UUID.randomUUID().toString());
        this.addPredicate(new IdPredicate(Graql.var(typeVariable).id(this.typeId).admin()));
        this.atomPattern = this.atomPattern.asVar().isa(Graql.var(typeVariable)).admin();
        this.setValueVariable(typeVariable);
    }

    private void inferTypeFromRoles() {
        if (this.getParentQuery() != null && !this.isValueUserDefinedName() && this.getTypeId() == null) {
            RelationType type = null;
            Set<RelationType> compatibleTypes = Utility.getCompatibleRelationTypes(this.getExplicitRoleTypes(), Utility.roleToRelationTypes);
            if (compatibleTypes.size() == 1) {
                type = compatibleTypes.iterator().next();
            }
            if (type == null) {
                Map<VarName, Type> varTypeMap = this.getParentQuery().getVarTypeMap();
                Set types = this.getRolePlayers().stream().filter(varTypeMap::containsKey).map(varTypeMap::get).collect(Collectors.toSet());
                Set<RelationType> compatibleTypesFromTypes = Utility.getCompatibleRelationTypes(types, Utility.typeToRelationTypes);
                if (compatibleTypesFromTypes.size() == 1) {
                    type = compatibleTypesFromTypes.iterator().next();
                } else {
                    compatibleTypesFromTypes.retainAll(compatibleTypes);
                    if (compatibleTypesFromTypes.size() == 1) {
                        type = compatibleTypesFromTypes.iterator().next();
                    }
                }
            }
            if (type != null) {
                this.addType((Type)type);
            }
        }
    }

    private void inferTypeFromHasRole() {
        if (this.getPredicate() == null && this.getParentQuery() != null) {
            Query parent = this.getParentQuery();
            VarName valueVariable = this.getValueVariable();
            HasRole hrAtom = parent.getAtoms().stream().filter(at -> at.getVarName().equals(valueVariable)).filter(at -> at instanceof HasRole).map(at -> (HasRole)at).findFirst().orElse(null);
            if (hrAtom != null) {
                AtomicMatchQuery hrQuery = new AtomicMatchQuery(hrAtom, Sets.newHashSet((Object[])new VarName[]{hrAtom.getVarName()}));
                ((Query)hrQuery).DBlookup();
                if (((Query)hrQuery).getAnswers().size() != 1) {
                    throw new IllegalStateException("ambigious answer to has-role query");
                }
                IdPredicate newPredicate = new IdPredicate(IdPredicate.createIdVar(hrAtom.getVarName(), ((Concept)((Map)((Query)hrQuery).getAnswers().stream().findFirst().orElse(null)).get(hrAtom.getVarName())).getId()), parent);
                Relation newRelation = new Relation(this.getPattern().asVar(), newPredicate, parent);
                parent.removeAtom(hrAtom.getPredicate());
                parent.removeAtom(hrAtom);
                parent.removeAtom(this);
                parent.addAtom(newRelation);
                parent.addAtom(newPredicate);
            }
        }
    }

    @Override
    public void inferTypes() {
        this.inferTypeFromRoles();
        this.inferTypeFromHasRole();
    }

    @Override
    public boolean containsVar(VarName name) {
        boolean varFound = false;
        Iterator<RelationPlayer> it = this.relationPlayers.iterator();
        while (it.hasNext() && !varFound) {
            varFound = it.next().getRolePlayer().getVarName().equals(name);
        }
        return varFound;
    }

    @Override
    public Set<Predicate> getIdPredicates() {
        Set<Predicate> idPredicates = super.getIdPredicates();
        this.getTypeConstraints().forEach(atom -> {
            IdPredicate predicate = this.getParentQuery().getIdPredicate(atom.getValueVariable());
            if (predicate != null) {
                idPredicates.add(predicate);
            }
        });
        return idPredicates;
    }

    @Override
    public void unify(Map<VarName, VarName> mappings) {
        super.unify(mappings);
        this.relationPlayers.forEach(c -> {
            VarName var = c.getRolePlayer().getVarName();
            if (mappings.containsKey(var)) {
                VarName target = (VarName)mappings.get(var);
                c.getRolePlayer().setVarName(target);
            } else if (mappings.containsValue(var)) {
                c.getRolePlayer().setVarName(Utility.capture(var));
            }
        });
    }

    @Override
    public Set<VarName> getVarNames() {
        Set<VarName> vars = super.getVarNames();
        vars.addAll(this.getRolePlayers());
        this.relationPlayers.stream().map(RelationPlayer::getRoleType).flatMap(CommonUtil::optionalToStream).filter(VarAdmin::isUserDefinedName).forEach(r -> vars.add(r.getVarName()));
        return vars;
    }

    @Override
    public Set<VarName> getSelectedNames() {
        Set<VarName> vars = super.getSelectedNames();
        vars.addAll(this.getRolePlayers());
        return vars;
    }

    public Set<VarName> getRolePlayers() {
        HashSet<VarName> vars = new HashSet<VarName>();
        this.relationPlayers.forEach(c -> vars.add(c.getRolePlayer().getVarName()));
        return vars;
    }

    private Map<VarName, Pair<Type, RoleType>> computeVarTypeRoleMap() {
        HashMap<VarName, Pair<Type, RoleType>> roleVarTypeMap = new HashMap<VarName, Pair<Type, RoleType>>();
        if (this.getParentQuery() == null) {
            return roleVarTypeMap;
        }
        GraknGraph graph = this.getParentQuery().graph();
        Type relType = this.getType();
        Set<VarName> vars = this.getRolePlayers();
        Map<VarName, Type> varTypeMap = this.getParentQuery().getVarTypeMap();
        for (VarName var : vars) {
            Type type = varTypeMap.get(var);
            String roleTypeName = "";
            for (RelationPlayer c : this.relationPlayers) {
                if (!c.getRolePlayer().getVarName().equals(var)) continue;
                roleTypeName = c.getRoleType().flatMap(VarAdmin::getTypeName).orElse("");
            }
            if (!roleTypeName.isEmpty()) {
                roleVarTypeMap.put(var, (Pair<Type, RoleType>)new Pair((Object)type, (Object)graph.getRoleType(roleTypeName)));
                continue;
            }
            if (type == null || relType == null) continue;
            Set<RoleType> cRoles = Utility.getCompatibleRoleTypes(type, relType);
            if (cRoles.size() == 1) {
                roleVarTypeMap.put(var, (Pair<Type, RoleType>)new Pair((Object)type, (Object)cRoles.iterator().next()));
                continue;
            }
            roleVarTypeMap.put(var, (Pair<Type, RoleType>)new Pair((Object)type, null));
        }
        return roleVarTypeMap;
    }

    @Override
    public Map<VarName, Pair<Type, RoleType>> getVarTypeRoleMap() {
        if (this.varTypeRoleMap == null) {
            this.varTypeRoleMap = this.computeVarTypeRoleMap();
        }
        return this.varTypeRoleMap;
    }

    private Map<RoleType, Pair<VarName, Type>> computeRoleVarTypeMap() {
        HashMap<Object, Pair> roleVarTypeMap = new HashMap<Object, Pair>();
        HashMap<RoleType, Pair<VarName, Type>> roleTypeMap = new HashMap<RoleType, Pair<VarName, Type>>();
        if (this.getParentQuery() == null || this.getType() == null) {
            return roleTypeMap;
        }
        GraknGraph graph = this.getParentQuery().graph();
        Map<VarName, Type> varTypeMap = this.getParentQuery().getVarTypeMap();
        HashSet allocatedVars = new HashSet();
        HashSet allocatedRoles = new HashSet();
        this.relationPlayers.forEach(c -> {
            VarName var = c.getRolePlayer().getVarName();
            VarAdmin role = c.getRoleType().orElse(null);
            if (role != null) {
                IdPredicate rolePredicate;
                RoleType roleType;
                Type type = (Type)varTypeMap.get(var);
                roleVarTypeMap.put(role, new Pair((Object)var, (Object)type));
                String typeName = role.getTypeName().orElse("");
                RoleType roleType2 = roleType = !typeName.isEmpty() ? graph.getRoleType(typeName) : null;
                if (roleType == null && role.isUserDefinedName() && (rolePredicate = this.getParentQuery().getIdPredicate(role.getVarName())) != null) {
                    roleType = (RoleType)graph.getConcept((ConceptId)rolePredicate.getPredicate());
                }
                allocatedVars.add(var);
                if (roleType != null) {
                    allocatedRoles.add(roleType);
                    roleTypeMap.put(roleType, new Pair((Object)var, (Object)type));
                }
            }
        });
        RelationType relType = (RelationType)this.getType();
        Set<VarName> varsToAllocate = this.getRolePlayers();
        varsToAllocate.removeAll(allocatedVars);
        varsToAllocate.forEach(var -> {
            Set<RoleType> cRoles;
            Type type = (Type)varTypeMap.get(var);
            if (type != null && relType != null && (cRoles = Utility.getCompatibleRoleTypes(type, (Type)relType)).size() == 1) {
                RoleType roleType = cRoles.iterator().next();
                VarAdmin roleVar = Graql.var().name(roleType.getName()).admin();
                roleVarTypeMap.put(roleVar, new Pair(var, (Object)type));
                allocatedVars.add(var);
                allocatedRoles.add(roleType);
                roleTypeMap.put(roleType, new Pair(var, (Object)type));
            }
        });
        Collection rolesToAllocate = relType.hasRoles();
        allocatedRoles.forEach(role -> {
            RoleType topRole = Utility.getNonMetaTopRole(role);
            rolesToAllocate.removeAll(topRole.subTypes());
        });
        varsToAllocate.removeAll(allocatedVars);
        if (varsToAllocate.size() == 1 && !rolesToAllocate.isEmpty()) {
            RoleType topRole = Utility.getNonMetaTopRole((RoleType)rolesToAllocate.iterator().next());
            VarName var2 = varsToAllocate.iterator().next();
            Type type = varTypeMap.get(var2);
            roleTypeMap.put(topRole, (Pair<VarName, Type>)new Pair((Object)var2, (Object)type));
            roleVarTypeMap.put(Graql.var().name(topRole.getName()).admin(), new Pair((Object)var2, (Object)type));
        }
        HashMap<VarName, Var> roleMap = new HashMap<VarName, Var>();
        roleVarTypeMap.forEach((r, tp) -> roleMap.put((VarName)tp.getKey(), (Var)r));
        this.getRolePlayers().stream().filter(var -> !var.equals(this.getVarName())).filter(var -> !roleMap.containsKey(var)).forEach(var -> {
            Var cfr_ignored_0 = roleMap.put((VarName)var, (Var)null);
        });
        this.atomPattern = Relation.constructRelationVar(this.isUserDefinedName() ? this.varName : Patterns.varName(""), this.getValueVariable(), roleMap);
        this.relationPlayers = this.getRelationPlayers(this.getPattern().asVar());
        return roleTypeMap;
    }

    @Override
    public Map<RoleType, Pair<VarName, Type>> getRoleVarTypeMap() {
        if (this.roleVarTypeMap == null) {
            if (this.varTypeRoleMap != null) {
                this.roleVarTypeMap = new HashMap<RoleType, Pair<VarName, Type>>();
                this.varTypeRoleMap.forEach((var, tpair) -> {
                    RoleType rt = (RoleType)tpair.getValue();
                    if (rt != null) {
                        this.roleVarTypeMap.put(rt, (Pair<VarName, Type>)new Pair(var, tpair.getKey()));
                    }
                });
            } else {
                this.roleVarTypeMap = this.computeRoleVarTypeMap();
            }
        }
        return this.roleVarTypeMap;
    }

    private Map<VarName, RoleType> getIndirectRoleMap() {
        GraknGraph graph = this.getParentQuery().graph();
        return this.getRelationPlayers().stream().map(RelationPlayer::getRoleType).flatMap(CommonUtil::optionalToStream).map(rt -> new AbstractMap.SimpleEntry<VarAdmin, IdPredicate>((VarAdmin)rt, this.getParentQuery().getIdPredicate(rt.getVarName()))).filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> ((VarAdmin)e.getKey()).getVarName(), e -> (RoleType)graph.getConcept((ConceptId)((IdPredicate)e.getValue()).getPredicate())));
    }

    private Map<VarName, VarName> getUnifiers(Map<VarName, RoleType> childMap, Map<RoleType, VarName> parentMap, Set<VarName> childBVs, Set<VarName> varsToAllocate) {
        HashMap<VarName, VarName> unifiers = new HashMap<VarName, VarName>();
        HashSet allocatedVars = new HashSet();
        childBVs.forEach(chVar -> {
            if (!varsToAllocate.isEmpty()) {
                VarName pVar = Patterns.varName("");
                for (RoleType role = (RoleType)childMap.get(chVar); role != null && pVar.getValue().isEmpty() && !Schema.MetaSchema.isMetaName((String)role.getName()); role = role.superType()) {
                    pVar = parentMap.getOrDefault(role, Patterns.varName(""));
                }
                if (!pVar.getValue().isEmpty() && !chVar.equals(pVar)) {
                    unifiers.put((VarName)chVar, pVar);
                    allocatedVars.add(chVar);
                    varsToAllocate.remove(pVar);
                }
            }
        });
        childBVs.removeAll(allocatedVars);
        Iterator<VarName> cit = childBVs.iterator();
        Iterator<VarName> pit = varsToAllocate.iterator();
        while (pit.hasNext() && cit.hasNext()) {
            unifiers.put(cit.next(), pit.next());
        }
        return unifiers;
    }

    private Map<VarName, VarName> getRoleTypeUnifiers(Relation parentAtom) {
        Map<VarName, RoleType> childMap = this.getIndirectRoleMap();
        Map<RoleType, VarName> parentMap = parentAtom.getIndirectRoleMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        HashSet indirectVarsToAllocate = Sets.newHashSet(parentMap.values());
        return this.getUnifiers(childMap, parentMap, childMap.keySet(), indirectVarsToAllocate);
    }

    private Map<VarName, VarName> getRolePlayerUnifiers(Relation parentAtom) {
        HashMap<VarName, RoleType> childMap = new HashMap<VarName, RoleType>();
        HashMap<RoleType, VarName> parentMap = new HashMap<RoleType, VarName>();
        this.getVarTypeRoleMap().entrySet().forEach(e -> {
            RoleType cfr_ignored_0 = (RoleType)childMap.put((VarName)e.getKey(), (RoleType)((Pair)e.getValue()).getValue());
        });
        parentAtom.getRoleVarTypeMap().entrySet().forEach(e -> {
            VarName cfr_ignored_0 = (VarName)parentMap.put((RoleType)e.getKey(), (VarName)((Pair)e.getValue()).getKey());
        });
        return this.getUnifiers(childMap, parentMap, this.getRolePlayers(), parentAtom.getRolePlayers());
    }

    @Override
    public Map<VarName, VarName> getUnifiers(Atomic pAtom) {
        if (!(pAtom instanceof TypeAtom)) {
            throw new IllegalArgumentException(ErrorMessage.UNIFICATION_ATOM_INCOMPATIBILITY.getMessage(new Object[0]));
        }
        Map<VarName, VarName> unifiers = super.getUnifiers(pAtom);
        if (((Atom)pAtom).isRelation()) {
            Relation parentAtom = (Relation)pAtom;
            unifiers.putAll(this.getRolePlayerUnifiers(parentAtom));
            unifiers.putAll(this.getRoleTypeUnifiers(parentAtom));
        }
        return unifiers;
    }

    private Map<VarName, Predicate> getVarSubMap() {
        HashMap<VarName, Predicate> map = new HashMap<VarName, Predicate>();
        this.getPredicates().stream().filter(Predicate::isIdPredicate).forEach(sub -> {
            VarName var = sub.getVarName();
            map.put(var, (Predicate)sub);
        });
        return map;
    }

    private Map<RoleType, String> getRoleConceptIdMap() {
        HashMap<RoleType, String> roleConceptMap = new HashMap<RoleType, String>();
        Map<VarName, Predicate> varSubMap = this.getVarSubMap();
        Map<RoleType, Pair<VarName, Type>> roleVarMap = this.getRoleVarTypeMap();
        roleVarMap.forEach((role, varTypePair) -> {
            VarName var = (VarName)varTypePair.getKey();
            roleConceptMap.put((RoleType)role, varSubMap.containsKey(var) ? ((Predicate)varSubMap.get(var)).getPredicateValue() : "");
        });
        return roleConceptMap;
    }

    @Override
    public Pair<Atom, Map<VarName, VarName>> rewrite(Atom parentAtom, Query parent) {
        if (parentAtom.isUserDefinedName()) {
            HashMap unifiers = new HashMap();
            Var relVar = Graql.var(UUID.randomUUID().toString());
            this.getPattern().asVar().getProperty(IsaProperty.class).ifPresent(prop -> relVar.isa((Var)prop.getType()));
            this.relationPlayers.forEach(c -> {
                VarAdmin rolePlayer = c.getRolePlayer();
                VarName rolePlayerVarName = Patterns.varName();
                unifiers.put(rolePlayer.getVarName(), rolePlayerVarName);
                VarAdmin roleType = c.getRoleType().orElse(null);
                if (roleType != null) {
                    relVar.rel((Var)roleType, Graql.var(rolePlayerVarName));
                } else {
                    relVar.rel(Graql.var(rolePlayerVarName));
                }
            });
            return new Pair((Object)new Relation(relVar.admin(), this.getPredicate(), parent), unifiers);
        }
        return new Pair((Object)this, new HashMap());
    }
}

