/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.concept.ConceptId;
import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.pattern.property.HasResourceProperty;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.Atomic;
import ai.grakn.graql.internal.reasoner.atom.binary.MultiPredicateBinary;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.query.Query;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;

public class Resource
extends MultiPredicateBinary {
    public Resource(VarAdmin pattern, Query par) {
        this(pattern, null, par);
    }

    public Resource(VarAdmin pattern, Set<Predicate> p, Query par) {
        super(pattern, p, par);
    }

    private Resource(Resource a) {
        super(a);
    }

    @Override
    protected boolean isRuleApplicable(InferenceRule child) {
        Atom ruleAtom = child.getHead().getAtom();
        if (!(ruleAtom instanceof Resource)) {
            return false;
        }
        boolean ruleApplicable = false;
        Resource childAtom = (Resource)ruleAtom;
        if (childAtom.getMultiPredicate().isEmpty() || this.getMultiPredicate().isEmpty()) {
            return true;
        }
        Iterator<Predicate> childIt = childAtom.getMultiPredicate().iterator();
        while (childIt.hasNext() && !ruleApplicable) {
            Predicate childPredicate = childIt.next();
            Iterator<Predicate> parentIt = this.getMultiPredicate().iterator();
            boolean predicateCompatible = false;
            while (parentIt.hasNext() && !predicateCompatible) {
                predicateCompatible = childPredicate.getPredicateValue().equals(parentIt.next().getPredicateValue());
            }
            ruleApplicable = predicateCompatible;
        }
        return ruleApplicable;
    }

    @Override
    protected ConceptId extractTypeId(VarAdmin var) {
        HasResourceProperty resProp = var.getProperties(HasResourceProperty.class).findFirst().orElse(null);
        String typeName = resProp != null ? resProp.getType().orElse("") : "";
        return !typeName.isEmpty() ? this.getParentQuery().graph().getType(typeName).getId() : null;
    }

    @Override
    protected VarName extractValueVariableName(VarAdmin var) {
        HasResourceProperty prop = var.getProperties(HasResourceProperty.class).findFirst().orElse(null);
        VarAdmin resVar = prop.getResource();
        return resVar.isUserDefinedName() ? resVar.getVarName() : Patterns.varName("");
    }

    @Override
    protected void setValueVariable(VarName var) {
        super.setValueVariable(var);
        this.atomPattern.asVar().getProperties(HasResourceProperty.class).forEach(prop -> prop.getResource().setVarName(var));
    }

    @Override
    public Atomic clone() {
        return new Resource(this);
    }

    @Override
    public boolean isResource() {
        return true;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean requiresMaterialisation() {
        return true;
    }

    @Override
    public Set<Predicate> getValuePredicates() {
        return this.getParentQuery().getValuePredicates().stream().filter(atom -> atom.getVarName().equals(this.getValueVariable())).collect(Collectors.toSet());
    }

    @Override
    public Set<VarName> getSelectedNames() {
        Set<VarName> vars = super.getSelectedNames();
        this.getMultiPredicate().forEach(pred -> vars.addAll(pred.getSelectedNames()));
        return vars;
    }
}

