/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.query;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Rule;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.VarName;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.query.AtomicQuery;
import ai.grakn.graql.internal.reasoner.query.Query;
import ai.grakn.graql.internal.reasoner.query.QueryAnswers;
import ai.grakn.graql.internal.reasoner.query.QueryCache;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicMatchQuery
extends AtomicQuery {
    private final QueryAnswers answers;
    private final QueryAnswers newAnswers;
    private static final Logger LOG = LoggerFactory.getLogger(AtomicQuery.class);

    public AtomicMatchQuery(Atom atom, Set<VarName> vars) {
        super(atom, vars);
        this.answers = new QueryAnswers();
        this.newAnswers = new QueryAnswers();
    }

    public AtomicMatchQuery(MatchQuery query, GraknGraph graph) {
        super(query, graph);
        this.answers = new QueryAnswers();
        this.newAnswers = new QueryAnswers();
    }

    public AtomicMatchQuery(AtomicQuery query, QueryAnswers ans) {
        super(query);
        this.answers = new QueryAnswers(ans);
        this.newAnswers = new QueryAnswers();
    }

    @Override
    public QueryAnswers getAnswers() {
        return this.answers;
    }

    @Override
    public QueryAnswers getNewAnswers() {
        return this.newAnswers;
    }

    @Override
    public void lookup(QueryCache cache) {
        boolean queryVisited = cache.contains(this);
        if (!queryVisited) {
            this.DBlookup();
            cache.record(this);
        } else {
            this.memoryLookup(cache);
        }
    }

    @Override
    public void DBlookup() {
        QueryAnswers lookup = new QueryAnswers(this.getMatchQuery().admin().streamWithVarNames().collect(Collectors.toList()));
        lookup.removeAll(this.answers);
        this.answers.addAll(lookup);
        this.newAnswers.addAll(lookup);
    }

    @Override
    public void memoryLookup(QueryCache cache) {
        AtomicQuery equivalentQuery = (AtomicQuery)cache.get(this);
        if (equivalentQuery != null) {
            QueryAnswers lookup = QueryAnswers.getUnifiedAnswers(this, equivalentQuery, equivalentQuery.getAnswers());
            lookup.removeAll(this.answers);
            this.answers.addAll(lookup);
            this.newAnswers.addAll(lookup);
        }
    }

    @Override
    public void propagateAnswers(QueryCache cache) {
        this.getChildren().forEach(childQuery -> {
            QueryAnswers ans = QueryAnswers.getUnifiedAnswers(childQuery, this, ((AtomicQuery)cache.get(this)).getAnswers());
            childQuery.getAnswers().addAll(ans);
            childQuery.getNewAnswers().addAll(ans);
            childQuery.propagateAnswers(cache);
        });
    }

    @Override
    public QueryAnswers materialise() {
        QueryAnswers fullAnswers = new QueryAnswers();
        this.answers.forEach(answer -> {
            HashSet<IdPredicate> subs = new HashSet<IdPredicate>();
            answer.forEach((var, con) -> {
                IdPredicate sub = new IdPredicate((VarName)var, (Concept)con);
                if (!this.containsAtom(sub)) {
                    subs.add(sub);
                }
            });
            fullAnswers.addAll(this.materialise(subs));
        });
        return fullAnswers;
    }

    private QueryAnswers propagateHeadIdPredicates(Query ruleHead, QueryAnswers answers) {
        QueryAnswers newAnswers = new QueryAnswers();
        if (answers.isEmpty()) {
            return newAnswers;
        }
        Set<VarName> queryVars = this.getSelectedNames();
        Set<VarName> headVars = ruleHead.getSelectedNames();
        HashSet extraSubs = new HashSet();
        if (queryVars.size() > headVars.size()) {
            extraSubs.addAll(ruleHead.getIdPredicates().stream().filter(sub -> queryVars.contains(sub.getVarName())).collect(Collectors.toSet()));
        }
        answers.forEach(map -> {
            HashMap newAns = new HashMap(map);
            extraSubs.forEach(sub -> newAns.put(sub.getVarName(), this.graph().getConcept((ConceptId)sub.getPredicate())));
            newAnswers.add(newAns);
        });
        return newAnswers;
    }

    @Override
    public void resolveViaRule(Rule rl, Set<AtomicQuery> subGoals, QueryCache cache, boolean materialise) {
        QueryAnswers newAnswers;
        Atom atom = this.getAtom();
        InferenceRule rule = new InferenceRule(rl, this.graph());
        rule.unify(atom);
        Query ruleBody = rule.getBody();
        AtomicQuery ruleHead = rule.getHead();
        Set<Atom> atoms = ruleBody.selectAtoms();
        Iterator<Atom> atIt = atoms.iterator();
        subGoals.add(this);
        AtomicMatchQuery childAtomicQuery = new AtomicMatchQuery(atIt.next(), this.getSelectedNames());
        if (!materialise) {
            this.establishRelation(childAtomicQuery);
        }
        QueryAnswers subs = ((AtomicQuery)childAtomicQuery).answer(subGoals, cache, materialise);
        while (atIt.hasNext()) {
            childAtomicQuery = new AtomicMatchQuery(atIt.next(), this.getSelectedNames());
            if (!materialise) {
                this.establishRelation(childAtomicQuery);
            }
            QueryAnswers localSubs = ((AtomicQuery)childAtomicQuery).answer(subGoals, cache, materialise);
            subs = subs.join(localSubs);
        }
        QueryAnswers answers = this.propagateHeadIdPredicates(ruleHead, subs).filterNonEquals(ruleBody).filterVars(ruleHead.getSelectedNames()).filterKnown(this.getAnswers());
        if ((materialise || ruleHead.getAtom().requiresMaterialisation()) && !(newAnswers = new AtomicMatchQuery(ruleHead, answers).materialise()).isEmpty()) {
            answers = materialise ? newAnswers : answers.join(newAnswers);
        }
        QueryAnswers filteredAnswers = answers.filterVars(this.getSelectedNames()).filterIncomplete(this.getSelectedNames());
        this.getAnswers().addAll(filteredAnswers);
        this.newAnswers.addAll(filteredAnswers);
        cache.record(this);
    }

    @Override
    public QueryAnswers answer(Set<AtomicQuery> subGoals, QueryCache cache, boolean materialise) {
        boolean queryAdmissible = !subGoals.contains(this);
        this.lookup(cache);
        if (queryAdmissible) {
            Atom atom = this.getAtom();
            Set<Rule> rules = atom.getApplicableRules();
            rules.forEach(rule -> this.resolveViaRule((Rule)rule, subGoals, cache, materialise));
        }
        return this.getAnswers();
    }

    @Override
    public Stream<Map<VarName, Concept>> resolve(boolean materialise) {
        if (!this.getAtom().isRuleResolvable()) {
            return this.getMatchQuery().admin().streamWithVarNames();
        }
        return new QueryAnswerIterator(materialise).hasStream();
    }

    private class QueryAnswerIterator
    implements Iterator<Map<VarName, Concept>> {
        private int dAns = 0;
        private int iter = 0;
        private final boolean materialise;
        private final QueryCache cache = new QueryCache();
        private final Set<AtomicQuery> subGoals = new HashSet<AtomicQuery>();
        private final Set<Rule> rules;
        private Iterator<Map<VarName, Concept>> answerIterator = Collections.emptyIterator();
        private Iterator<Rule> ruleIterator = Collections.emptyIterator();

        public QueryAnswerIterator(boolean materialise) {
            this.materialise = materialise;
            this.rules = this.outer().getAtom().getApplicableRules();
            AtomicMatchQuery.this.lookup(this.cache);
            this.answerIterator = this.outer().newAnswers.iterator();
        }

        public Stream<Map<VarName, Concept>> hasStream() {
            Iterable iterable = () -> this;
            return StreamSupport.stream(iterable.spliterator(), false);
        }

        private boolean hasNextRule() {
            return this.ruleIterator.hasNext();
        }

        private Rule nextRule() {
            return this.ruleIterator.next();
        }

        private void initIteration() {
            this.ruleIterator = this.rules.iterator();
            this.dAns = this.size();
            this.subGoals.clear();
        }

        private void completeIteration() {
            LOG.debug("Atom: " + this.outer().getAtom() + " iter: " + this.iter + " answers: " + this.size());
            this.dAns = this.size() - this.dAns;
            ++this.iter;
            if (!this.materialise) {
                this.cache.propagateAnswers();
            }
        }

        private void computeNext() {
            if (!this.hasNextRule()) {
                this.initIteration();
            }
            this.outer().newAnswers.clear();
            Rule rule = this.nextRule();
            LOG.debug("Resolving rule: " + rule.getId() + " answers: " + this.size());
            this.outer().resolveViaRule(rule, this.subGoals, this.cache, this.materialise);
            if (!this.hasNextRule()) {
                this.completeIteration();
            }
            this.answerIterator = this.outer().newAnswers.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.answerIterator.hasNext()) {
                return true;
            }
            if (this.dAns != 0 || this.iter == 0) {
                this.computeNext();
                return this.hasNext();
            }
            return false;
        }

        @Override
        public Map<VarName, Concept> next() {
            return this.answerIterator.next();
        }

        private AtomicMatchQuery outer() {
            return AtomicMatchQuery.this;
        }

        private int size() {
            return this.outer().getAnswers().size();
        }
    }
}

