/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.query;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Type;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.VarName;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.reasoner.Utility;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.Atomic;
import ai.grakn.graql.internal.reasoner.atom.AtomicFactory;
import ai.grakn.graql.internal.reasoner.atom.NotEquals;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.query.QueryAnswers;
import ai.grakn.graql.internal.reasoner.query.QueryCache;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Query {
    private final GraknGraph graph;
    private final Set<Atomic> atomSet = new HashSet<Atomic>();
    private final Set<VarName> selectVars;

    public Query(MatchQuery query, GraknGraph graph) {
        this.graph = graph;
        this.selectVars = Sets.newHashSet((Iterable)query.admin().getSelectedNames());
        this.atomSet.addAll(AtomicFactory.createAtomSet((Conjunction<PatternAdmin>)query.admin().getPattern(), this, graph));
        this.inferTypes();
    }

    public Query(String query, GraknGraph graph) {
        this((MatchQuery)graph.graql().infer(false).parse(query), graph);
    }

    public Query(Query q) {
        this.graph = q.graph;
        this.selectVars = q.getSelectedNames();
        q.getAtoms().forEach(at -> this.addAtom(AtomicFactory.create(at, this)));
        this.inferTypes();
    }

    protected Query(Atom atom, Set<VarName> vars) {
        if (atom.getParentQuery() == null) {
            throw new IllegalArgumentException(ErrorMessage.PARENT_MISSING.getMessage(new Object[]{atom.toString()}));
        }
        this.graph = atom.getParentQuery().graph;
        this.selectVars = atom.getSelectedNames();
        this.selectVars.addAll(vars);
        this.addAtom(AtomicFactory.create(atom, this));
        this.addAtomConstraints(atom);
        this.selectVars.retainAll(this.getVarSet());
        this.inferTypes();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Query a2 = (Query)obj;
        return this.isEquivalent(a2);
    }

    public int hashCode() {
        int hashCode = 1;
        TreeSet hashes = new TreeSet();
        this.atomSet.forEach(atom -> hashes.add(atom.equivalenceHashCode()));
        for (Integer hash : hashes) {
            hashCode = hashCode * 37 + hash;
        }
        return hashCode;
    }

    public String toString() {
        return this.getMatchQuery().toString();
    }

    private void inferTypes() {
        this.getAtoms().stream().filter(Atomic::isAtom).map(at -> (Atom)at).forEach(Atom::inferTypes);
    }

    public Set<VarName> getSelectedNames() {
        return Sets.newHashSet(this.selectVars);
    }

    public void selectAppend(Set<VarName> vars) {
        this.selectVars.addAll(vars);
    }

    public GraknGraph graph() {
        return this.graph;
    }

    public Conjunction<PatternAdmin> getPattern() {
        HashSet patterns = new HashSet();
        this.atomSet.stream().map(Atomic::getCombinedPattern).forEach(patterns::add);
        return Patterns.conjunction(patterns);
    }

    public boolean isRuleResolvable() {
        boolean ruleResolvable = false;
        Iterator<Atomic> it = this.atomSet.iterator();
        while (it.hasNext() && !ruleResolvable) {
            ruleResolvable = it.next().isRuleResolvable();
        }
        return ruleResolvable;
    }

    public QueryAnswers getAnswers() {
        throw new IllegalStateException(ErrorMessage.ANSWER_ERROR.getMessage(new Object[0]));
    }

    public QueryAnswers getNewAnswers() {
        throw new IllegalStateException(ErrorMessage.ANSWER_ERROR.getMessage(new Object[0]));
    }

    public void lookup(QueryCache cache) {
        throw new IllegalStateException(ErrorMessage.ANSWER_ERROR.getMessage(new Object[0]));
    }

    public void DBlookup() {
        throw new IllegalStateException(ErrorMessage.ANSWER_ERROR.getMessage(new Object[0]));
    }

    public void memoryLookup(QueryCache cache) {
        throw new IllegalStateException(ErrorMessage.ANSWER_ERROR.getMessage(new Object[0]));
    }

    public void propagateAnswers(QueryCache cache) {
        throw new IllegalStateException(ErrorMessage.ANSWER_ERROR.getMessage(new Object[0]));
    }

    public Set<Atomic> getAtoms() {
        return Sets.newHashSet(this.atomSet);
    }

    public Set<IdPredicate> getIdPredicates() {
        return this.getAtoms().stream().filter(Atomic::isPredicate).map(at -> (Predicate)at).filter(Predicate::isIdPredicate).map(predicate -> (IdPredicate)predicate).collect(Collectors.toSet());
    }

    public Set<Predicate> getValuePredicates() {
        return this.getAtoms().stream().filter(Atomic::isPredicate).map(at -> (Predicate)at).filter(Predicate::isValuePredicate).collect(Collectors.toSet());
    }

    public Set<Atom> getResources() {
        return this.getAtoms().stream().filter(Atomic::isAtom).map(at -> (Atom)at).filter(Atom::isResource).collect(Collectors.toSet());
    }

    public Set<Atom> getTypeConstraints() {
        return this.getAtoms().stream().filter(Atomic::isAtom).map(at -> (Atom)at).filter(Atom::isType).collect(Collectors.toSet());
    }

    public Set<NotEquals> getFilters() {
        return this.getAtoms().stream().filter(at -> at.getClass() == NotEquals.class).map(at -> (NotEquals)at).collect(Collectors.toSet());
    }

    public Set<VarName> getVarSet() {
        HashSet<VarName> vars = new HashSet<VarName>();
        this.atomSet.forEach(atom -> vars.addAll(atom.getVarNames()));
        return vars;
    }

    public boolean containsAtom(Atomic atom) {
        return this.atomSet.contains(atom);
    }

    public boolean containsEquivalentAtom(Atomic atom) {
        boolean isContained = false;
        Iterator<Atomic> it = this.atomSet.iterator();
        while (it.hasNext() && !isContained) {
            Atomic at = it.next();
            isContained = atom.isEquivalent(at);
        }
        return isContained;
    }

    private void updateSelectedVars(Map<VarName, VarName> mappings) {
        HashSet toRemove = new HashSet();
        HashSet toAdd = new HashSet();
        mappings.forEach((from, to) -> {
            if (this.selectVars.contains(from)) {
                toRemove.add(from);
                toAdd.add(to);
            }
        });
        toRemove.forEach(this.selectVars::remove);
        toAdd.forEach(this.selectVars::add);
    }

    private void exchangeRelVarNames(VarName from, VarName to) {
        this.unify(to, Patterns.varName("temp"));
        this.unify(from, to);
        this.unify(Patterns.varName("temp"), from);
    }

    public void unify(VarName from, VarName to) {
        HashSet toRemove = new HashSet();
        HashSet toAdd = new HashSet();
        this.atomSet.stream().filter(atom -> atom.getVarNames().contains(from)).forEach(toRemove::add);
        toRemove.forEach(atom -> toAdd.add(AtomicFactory.create(atom, this)));
        toRemove.forEach(this::removeAtom);
        toAdd.forEach(atom -> atom.unify((Map<VarName, VarName>)ImmutableMap.of((Object)from, (Object)to)));
        toAdd.forEach(this::addAtom);
        HashMap<VarName, VarName> mapping = new HashMap<VarName, VarName>();
        mapping.put(from, to);
        this.updateSelectedVars(mapping);
    }

    public void unify(Map<VarName, VarName> unifiers) {
        if (unifiers.size() == 0) {
            return;
        }
        HashMap<VarName, VarName> mappings = new HashMap<VarName, VarName>(unifiers);
        HashMap<VarName, VarName> appliedMappings = new HashMap<VarName, VarName>();
        for (Map.Entry mapping : mappings.entrySet()) {
            VarName varToReplace = (VarName)mapping.getKey();
            VarName replacementVar = (VarName)mapping.getValue();
            if (appliedMappings.containsKey(varToReplace) && ((VarName)appliedMappings.get(varToReplace)).equals(replacementVar) || !mappings.containsKey(replacementVar) || !((VarName)mappings.get(replacementVar)).equals(varToReplace)) continue;
            this.exchangeRelVarNames(varToReplace, replacementVar);
            appliedMappings.put(varToReplace, replacementVar);
            appliedMappings.put(replacementVar, varToReplace);
        }
        mappings.entrySet().removeIf(e -> appliedMappings.containsKey(e.getKey()) && ((VarName)appliedMappings.get(e.getKey())).equals(e.getValue()));
        HashSet toRemove = new HashSet();
        HashSet toAdd = new HashSet();
        this.atomSet.stream().filter(atom -> {
            Set<VarName> keyIntersection = atom.getVarNames();
            Set<VarName> valIntersection = atom.getVarNames();
            keyIntersection.retainAll(mappings.keySet());
            valIntersection.retainAll(mappings.values());
            return !keyIntersection.isEmpty() || !valIntersection.isEmpty();
        }).forEach(toRemove::add);
        toRemove.forEach(atom -> toAdd.add(AtomicFactory.create(atom, this)));
        toRemove.forEach(this::removeAtom);
        toAdd.forEach(atom -> atom.unify(mappings));
        toAdd.forEach(this::addAtom);
        mappings.putAll(this.resolveCaptures());
        this.updateSelectedVars(mappings);
    }

    private Map<VarName, VarName> resolveCaptures() {
        HashMap<VarName, VarName> newMappings = new HashMap<VarName, VarName>();
        HashSet captures = new HashSet();
        this.getVarSet().forEach(v -> {
            if (Utility.isCaptured(v)) {
                captures.add(v);
            }
        });
        captures.forEach(cap -> {
            VarName old = Utility.uncapture(cap);
            VarName fresh = Utility.createFreshVariable(this.getVarSet(), old);
            this.unify((VarName)cap, fresh);
            newMappings.put(old, fresh);
        });
        return newMappings;
    }

    public MatchQuery getMatchQuery() {
        if (this.selectVars.isEmpty()) {
            return this.graph.graql().infer(false).match(new Pattern[]{this.getPattern()});
        }
        return this.graph.graql().infer(false).match(new Pattern[]{this.getPattern()}).select(this.selectVars);
    }

    public Map<VarName, Type> getVarTypeMap() {
        HashMap<VarName, Type> map = new HashMap<VarName, Type>();
        this.getTypeConstraints().forEach(atom -> map.putIfAbsent(atom.getVarName(), atom.getType()));
        return map;
    }

    public IdPredicate getIdPredicate(VarName var) {
        Set relevantSubs = this.getIdPredicates().stream().filter(sub -> sub.getVarName().equals(var)).collect(Collectors.toSet());
        this.getTypeConstraints().stream().filter(type -> type.getVarName().equals(var)).forEach(type -> type.getPredicates().stream().findFirst().ifPresent(predicate -> relevantSubs.add((IdPredicate)predicate)));
        return relevantSubs.isEmpty() ? null : (IdPredicate)relevantSubs.iterator().next();
    }

    public boolean addAtom(Atomic atom) {
        if (this.atomSet.add(atom)) {
            atom.setParentQuery(this);
            return true;
        }
        return false;
    }

    public boolean removeAtom(Atomic atom) {
        return this.atomSet.remove(atom);
    }

    private void addAtomConstraints(Atom atom) {
        this.addAtomConstraints(atom.getPredicates());
        Set types = atom.getTypeConstraints().stream().filter(at -> !at.isSelectable()).filter(at -> !at.isRuleResolvable()).collect(Collectors.toSet());
        this.addAtomConstraints(types);
    }

    public void addAtomConstraints(Set<? extends Atomic> cstrs) {
        cstrs.forEach(con -> this.addAtom(AtomicFactory.create(con, this)));
    }

    public Set<Atom> selectAtoms() {
        Set<Atom> atoms = new HashSet<Atomic>(this.atomSet).stream().filter(Atomic::isAtom).map(at -> (Atom)at).collect(Collectors.toSet());
        if (atoms.size() == 1) {
            return atoms;
        }
        Set selectedAtoms = atoms.stream().filter(atom -> atom.isSelectable() || atom.isRuleResolvable()).collect(Collectors.toSet());
        LinkedHashSet<Atom> orderedSelection = new LinkedHashSet<Atom>();
        this.getVarSet().forEach(var -> orderedSelection.addAll(selectedAtoms.stream().filter(atom -> atom.containsVar((VarName)var)).collect(Collectors.toSet())));
        if (orderedSelection.isEmpty()) {
            throw new IllegalStateException(ErrorMessage.NO_ATOMS_SELECTED.getMessage(new Object[]{this.toString()}));
        }
        return orderedSelection;
    }

    public boolean isEquivalent(Query q) {
        boolean equivalent = true;
        Set atoms = this.atomSet.stream().filter(Atomic::isAtom).map(at -> (Atom)at).collect(Collectors.toSet());
        if ((long)atoms.size() != q.getAtoms().stream().filter(Atomic::isAtom).count()) {
            return false;
        }
        Iterator it = atoms.iterator();
        while (it.hasNext() && equivalent) {
            Atom atom = (Atom)it.next();
            equivalent = q.containsEquivalentAtom(atom);
        }
        return equivalent;
    }

    public Stream<Map<VarName, Concept>> resolve(boolean materialise) {
        throw new IllegalStateException(ErrorMessage.ANSWER_ERROR.getMessage(new Object[0]));
    }
}

