/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.query;

import ai.grakn.concept.Concept;
import ai.grakn.graql.VarName;
import ai.grakn.graql.internal.reasoner.atom.NotEquals;
import ai.grakn.graql.internal.reasoner.query.Query;
import ai.grakn.graql.internal.reasoner.query.QueryAnswers;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QueryAnswerStream {
    private final Stream<Map<VarName, Concept>> stream;
    public static final BiFunction<Map<VarName, Concept>, Set<VarName>, Stream<Map<VarName, Concept>>> varFilterFunction = (a, vars) -> {
        Map<VarName, Concept> filteredAnswer = QueryAnswerStream.varFilterOperator(a, vars);
        return filteredAnswer.isEmpty() ? Stream.empty() : Stream.of(filteredAnswer);
    };
    public static final BiFunction<Map<VarName, Concept>, QueryAnswers, Stream<Map<VarName, Concept>>> knownFilterFunction = (a, known) -> QueryAnswerStream.knownFilterOperator(a, known) ? Stream.empty() : Stream.of(a);
    public static final BiFunction<Map<VarName, Concept>, Set<VarName>, Stream<Map<VarName, Concept>>> incompleteFilterFunction = (a, vars) -> a.keySet().containsAll((Collection<?>)vars) ? Stream.of(a) : Stream.empty();
    public static final BiFunction<Map<VarName, Concept>, Set<NotEquals>, Stream<Map<VarName, Concept>>> nonEqualsFilterFunction = (a, atoms) -> QueryAnswerStream.nonEqualsOperator(a, atoms) ? Stream.empty() : Stream.of(a);
    private static final BiFunction<Map<VarName, Concept>, Map<VarName, Concept>, Stream<Map<VarName, Concept>>> joinFunction = (a1, a2) -> {
        Map<VarName, Concept> merged = QueryAnswerStream.joinOperator(a1, a2);
        return merged.isEmpty() ? Stream.empty() : Stream.of(merged);
    };

    public QueryAnswerStream(Stream<Map<VarName, Concept>> s) {
        this.stream = s;
    }

    public Stream<Map<VarName, Concept>> stream() {
        return this.stream;
    }

    private static Map<VarName, Concept> varFilterOperator(Map<VarName, Concept> answer, Set<VarName> vars) {
        HashMap<VarName, Concept> filteredAnswer = new HashMap<VarName, Concept>();
        vars.stream().filter(answer::containsKey).forEach(var -> {
            Concept cfr_ignored_0 = (Concept)filteredAnswer.put((VarName)var, (Concept)answer.get(var));
        });
        return filteredAnswer;
    }

    private static boolean knownFilterOperator(Map<VarName, Concept> answer, QueryAnswers known) {
        boolean isKnown = false;
        Iterator it = known.iterator();
        while (it.hasNext() && !isKnown) {
            Map knownAnswer = (Map)it.next();
            isKnown = knownAnswer.entrySet().containsAll(answer.entrySet());
        }
        return !isKnown;
    }

    private static boolean nonEqualsOperator(Map<VarName, Concept> answer, Set<NotEquals> atoms) {
        if (atoms.isEmpty()) {
            return false;
        }
        boolean filter = false;
        Iterator<NotEquals> it = atoms.iterator();
        while (it.hasNext() && !filter) {
            filter = NotEquals.notEqualsOperator(answer, it.next());
        }
        return filter;
    }

    public QueryAnswerStream filterVars(Set<VarName> vars) {
        return new QueryAnswerStream(this.stream.flatMap(a -> varFilterFunction.apply((Map<VarName, Concept>)a, vars)));
    }

    public QueryAnswerStream filterKnown(QueryAnswers known) {
        return new QueryAnswerStream(this.stream.flatMap(a -> knownFilterFunction.apply((Map<VarName, Concept>)a, known)));
    }

    public QueryAnswerStream filterIncomplete(Set<VarName> vars) {
        return new QueryAnswerStream(this.stream.flatMap(a -> incompleteFilterFunction.apply((Map<VarName, Concept>)a, vars)));
    }

    public QueryAnswerStream filterNonEquals(Query query) {
        Set<NotEquals> filters = query.getFilters();
        if (filters.isEmpty()) {
            return new QueryAnswerStream(this.stream);
        }
        return new QueryAnswerStream(this.stream.flatMap(a -> nonEqualsFilterFunction.apply((Map<VarName, Concept>)a, filters)));
    }

    private static Map<VarName, Concept> joinOperator(Map<VarName, Concept> m1, Map<VarName, Concept> m2) {
        boolean isCompatible = true;
        HashSet<VarName> keysToCompare = new HashSet<VarName>(m1.keySet());
        keysToCompare.retainAll(m2.keySet());
        Iterator it = keysToCompare.iterator();
        while (it.hasNext() && isCompatible) {
            VarName var = (VarName)it.next();
            isCompatible = m1.get(var).equals(m2.get(var));
        }
        if (isCompatible) {
            HashMap<VarName, Concept> merged = new HashMap<VarName, Concept>(m1);
            merged.putAll(m2);
            return merged;
        }
        return new HashMap<VarName, Concept>();
    }

    public QueryAnswerStream join(QueryAnswerStream stream2) {
        Stream<Map<Object, Object>> result = this.stream;
        Collection c = stream2.stream().collect(Collectors.toSet());
        result = result.flatMap(a1 -> c.stream().flatMap(a2 -> joinFunction.apply((Map<VarName, Concept>)a1, (Map<VarName, Concept>)a2)));
        return new QueryAnswerStream(result);
    }

    public static Stream<Map<VarName, Concept>> join(Stream<Map<VarName, Concept>> stream, Stream<Map<VarName, Concept>> stream2) {
        Collection c = stream2.collect(Collectors.toSet());
        return stream.flatMap(a1 -> c.stream().flatMap(a2 -> joinFunction.apply((Map<VarName, Concept>)a1, (Map<VarName, Concept>)a2)));
    }
}

