/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.query;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.VarName;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.query.AtomicMatchQuery;
import ai.grakn.graql.internal.reasoner.query.Query;
import ai.grakn.graql.internal.reasoner.query.QueryAnswerStream;
import ai.grakn.graql.internal.reasoner.query.QueryAnswers;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;

public class ReasonerMatchQuery
extends Query {
    private final QueryAnswers answers;

    public ReasonerMatchQuery(MatchQuery query, GraknGraph graph) {
        super(query, graph);
        this.answers = new QueryAnswers();
    }

    public ReasonerMatchQuery(MatchQuery query, GraknGraph graph, QueryAnswers ans) {
        super(query, graph);
        this.answers = new QueryAnswers(ans);
    }

    @Override
    public Stream<Map<VarName, Concept>> resolve(boolean materialise) {
        if (!this.isRuleResolvable()) {
            return this.getMatchQuery().admin().streamWithVarNames();
        }
        Iterator<Atom> atIt = this.selectAtoms().iterator();
        AtomicMatchQuery atomicQuery = new AtomicMatchQuery(atIt.next(), this.getSelectedNames());
        Stream<Map<VarName, Concept>> answerStream = ((Query)atomicQuery).resolve(materialise);
        while (atIt.hasNext()) {
            atomicQuery = new AtomicMatchQuery(atIt.next(), this.getSelectedNames());
            Stream<Map<VarName, Concept>> subAnswerStream = ((Query)atomicQuery).resolve(materialise);
            answerStream = QueryAnswerStream.join(answerStream, subAnswerStream);
        }
        return answerStream.flatMap(a -> QueryAnswerStream.nonEqualsFilterFunction.apply((Map<VarName, Concept>)a, this.getFilters())).flatMap(a -> QueryAnswerStream.varFilterFunction.apply((Map<VarName, Concept>)a, this.getSelectedNames()));
    }
}

