/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.template;

import ai.grakn.exception.GraqlParsingException;
import ai.grakn.graql.internal.antlr.GraqlTemplateLexer;
import ai.grakn.graql.internal.antlr.GraqlTemplateParser;
import ai.grakn.graql.internal.parser.GraqlErrorListener;
import ai.grakn.graql.internal.template.TemplateVisitor;
import ai.grakn.graql.internal.template.macro.BooleanMacro;
import ai.grakn.graql.internal.template.macro.ConcatMacro;
import ai.grakn.graql.internal.template.macro.DateMacro;
import ai.grakn.graql.internal.template.macro.DoubleMacro;
import ai.grakn.graql.internal.template.macro.EqualsMacro;
import ai.grakn.graql.internal.template.macro.IntMacro;
import ai.grakn.graql.internal.template.macro.LongMacro;
import ai.grakn.graql.internal.template.macro.LowerMacro;
import ai.grakn.graql.internal.template.macro.NoescpMacro;
import ai.grakn.graql.internal.template.macro.SplitMacro;
import ai.grakn.graql.internal.template.macro.StringMacro;
import ai.grakn.graql.internal.template.macro.UpperMacro;
import ai.grakn.graql.macro.Macro;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class TemplateParser {
    private final Map<String, Macro<?>> macros = new HashMap();

    private TemplateParser() {
        this.registerDefaultMacros();
    }

    public static TemplateParser create() {
        return new TemplateParser();
    }

    public void registerMacro(String name, Macro macro) {
        this.macros.put(name, macro);
    }

    public String parseTemplate(String templateString, Map<String, Object> data) {
        GraqlErrorListener errorListener = new GraqlErrorListener(templateString);
        CommonTokenStream tokens = this.lexGraqlTemplate(templateString, errorListener);
        ParseTree tree = this.parseGraqlTemplate(tokens, errorListener);
        TemplateVisitor visitor = new TemplateVisitor(tokens, data, this.macros);
        return visitor.visit(tree).toString();
    }

    private CommonTokenStream lexGraqlTemplate(String templateString, GraqlErrorListener errorListener) {
        ANTLRInputStream inputStream = new ANTLRInputStream(templateString);
        GraqlTemplateLexer lexer = new GraqlTemplateLexer((CharStream)inputStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        return new CommonTokenStream((TokenSource)lexer);
    }

    private ParseTree parseGraqlTemplate(CommonTokenStream tokens, GraqlErrorListener errorListener) {
        GraqlTemplateParser parser = new GraqlTemplateParser((TokenStream)tokens);
        parser.setBuildParseTree(true);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        GraqlTemplateParser.TemplateContext tree = parser.template();
        if (errorListener.hasErrors()) {
            throw new GraqlParsingException(errorListener.toString());
        }
        return tree;
    }

    private void registerDefaultMacros() {
        this.registerMacro("noescp", new NoescpMacro());
        this.registerMacro("int", new IntMacro());
        this.registerMacro("double", new DoubleMacro());
        this.registerMacro("equals", new EqualsMacro());
        this.registerMacro("string", new StringMacro());
        this.registerMacro("long", new LongMacro());
        this.registerMacro("date", new DateMacro());
        this.registerMacro("lower", new LowerMacro());
        this.registerMacro("upper", new UpperMacro());
        this.registerMacro("boolean", new BooleanMacro());
        this.registerMacro("split", new SplitMacro());
        this.registerMacro("concat", new ConcatMacro());
    }
}

