/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.util;

import ai.grakn.graql.internal.antlr.GraqlLexer;
import ai.grakn.graql.internal.util.CommonUtil;
import com.google.common.collect.ImmutableSet;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.stream.Stream;
import org.apache.commons.lang.StringEscapeUtils;

public class StringConverter {
    private static final ImmutableSet<String> ALLOWED_ID_KEYWORDS = ImmutableSet.of((Object)"min", (Object)"max", (Object)"median", (Object)"mean", (Object)"std", (Object)"sum", (Object[])new String[]{"count", "path", "cluster", "degrees", "members", "persist"});
    public static final ImmutableSet<String> GRAQL_KEYWORDS = StringConverter.getKeywords().collect(CommonUtil.toImmutableSet());

    private StringConverter() {
    }

    public static String unescapeString(String string) {
        return StringEscapeUtils.unescapeJavaScript((String)string);
    }

    public static String escapeString(String string) {
        return StringEscapeUtils.escapeJavaScript((String)string);
    }

    private static String quoteString(String string) {
        return "\"" + StringConverter.escapeString(string) + "\"";
    }

    public static String valueToString(Object value) {
        if (value instanceof String) {
            return StringConverter.quoteString((String)value);
        }
        if (value instanceof Double) {
            DecimalFormat df = new DecimalFormat("#");
            df.setMinimumFractionDigits(1);
            df.setMaximumFractionDigits(12);
            df.setMinimumIntegerDigits(1);
            return df.format(value);
        }
        return value.toString();
    }

    public static String idToString(String id) {
        if (id.matches("^[a-zA-Z_][a-zA-Z0-9_-]*$") && !GRAQL_KEYWORDS.contains((Object)id)) {
            return id;
        }
        return StringConverter.quoteString(id);
    }

    private static Stream<String> getKeywords() {
        HashSet<String> keywords = new HashSet<String>();
        int i = 1;
        while (GraqlLexer.VOCABULARY.getLiteralName(i) != null) {
            String name = GraqlLexer.VOCABULARY.getLiteralName(i);
            keywords.add(name.replaceAll("'", ""));
            ++i;
        }
        return keywords.stream().filter(keyword -> !ALLOWED_ID_KEYWORDS.contains(keyword));
    }
}

